/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os;

import de.flapdoodle.os.Architecture;
import de.flapdoodle.os.CommonArchitecture;
import de.flapdoodle.os.Distribution;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.common.DistinctPeculiarity;
import de.flapdoodle.os.common.HasPecularities;
import de.flapdoodle.os.common.Peculiarity;
import de.flapdoodle.os.common.attributes.Attribute;
import de.flapdoodle.os.common.attributes.Attributes;
import de.flapdoodle.os.common.collections.Enums;
import de.flapdoodle.os.common.matcher.Match;
import de.flapdoodle.os.common.matcher.Matchers;
import de.flapdoodle.os.freebsd.FreeBSDDistribution;
import de.flapdoodle.os.linux.LinuxDistribution;
import de.flapdoodle.os.osx.OS_X_Distribution;
import de.flapdoodle.os.solaris.SolarisDistribution;
import de.flapdoodle.os.windows.WindowsDistribution;
import java.util.Arrays;
import java.util.List;

public enum CommonOS implements OS
{
    Linux(CommonArchitecture.class, LinuxDistribution.class, CommonOS.osNameMatches("Linux")),
    Windows(CommonArchitecture.class, WindowsDistribution.class, CommonOS.osNameMatches("Windows.*")),
    OS_X(CommonArchitecture.class, OS_X_Distribution.class, CommonOS.osNameMatches("Mac CommonOS X")),
    Solaris(CommonArchitecture.class, SolarisDistribution.class, CommonOS.osNameMatches(".*SunOS.*")),
    FreeBSD(CommonArchitecture.class, FreeBSDDistribution.class, CommonOS.osNameMatches("FreeBSD"));

    private final List<Peculiarity> peculiarities;
    private final List<? extends Distribution> distributions;
    private final List<? extends Architecture> architectures;

    private <A extends Enum<A>, T extends Enum<T>> CommonOS(Class<A> architecureClazz, Class<T> clazz, DistinctPeculiarity<?> ... peculiarities) {
        this.peculiarities = HasPecularities.asList(peculiarities);
        this.architectures = Enums.valuesAsList(architecureClazz);
        this.distributions = Enums.valuesAsList(clazz);
    }

    public List<? extends Distribution> distributions() {
        return this.distributions;
    }

    public List<? extends Architecture> architectures() {
        return this.architectures;
    }

    public List<Peculiarity> pecularities() {
        return this.peculiarities;
    }

    private static DistinctPeculiarity<String> osNameMatches(String pattern) {
        return DistinctPeculiarity.of((Attribute)Attributes.systemProperty((String)"os.name"), (Match)Matchers.matchPattern((String)pattern));
    }

    public static List<? extends OS> list() {
        return Arrays.asList(CommonOS.values());
    }
}

