/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.linux;

import de.flapdoodle.os.Distribution;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.common.HasPecularities;
import de.flapdoodle.os.common.OneOf;
import de.flapdoodle.os.common.Peculiarity;
import de.flapdoodle.os.common.collections.Enums;
import de.flapdoodle.os.linux.AmazonVersion;
import de.flapdoodle.os.linux.CentosVersion;
import de.flapdoodle.os.linux.DebianVersion;
import de.flapdoodle.os.linux.LinuxMintVersion;
import de.flapdoodle.os.linux.OpenSUSEVersion;
import de.flapdoodle.os.linux.OracleVersion;
import de.flapdoodle.os.linux.OsReleaseFiles;
import de.flapdoodle.os.linux.RedhatVersion;
import de.flapdoodle.os.linux.UbuntuVersion;
import java.util.List;

public enum LinuxDistribution implements Distribution
{
    Ubuntu(UbuntuVersion.class, new Peculiarity[]{OsReleaseFiles.osReleaseFileNameMatches("Ubuntu")}),
    CentOS(CentosVersion.class, CentosVersion.centosReleaseFileNameMatches("CentOS")),
    Redhat(RedhatVersion.class, new Peculiarity[]{OsReleaseFiles.osReleaseFileNameMatches("Red Hat")}),
    Oracle(OracleVersion.class, new Peculiarity[]{OsReleaseFiles.osReleaseFileNameMatches("Oracle")}),
    OpenSUSE(OpenSUSEVersion.class, new Peculiarity[]{OsReleaseFiles.osReleaseFileNameMatches("openSUSE")}),
    LinuxMint(LinuxMintVersion.class, new Peculiarity[]{OsReleaseFiles.osReleaseFileNameMatches("Linux Mint")}),
    Debian(DebianVersion.class, new Peculiarity[]{OsReleaseFiles.osReleaseFileNameMatches("Debian")}),
    Amazon(AmazonVersion.class, new Peculiarity[]{OneOf.of((Peculiarity[])new Peculiarity[]{OsReleaseFiles.osReleaseFileNameMatches("Amazon Linux"), AmazonVersion.osVersionMatches(".*amzn.*")})});

    private final List<Peculiarity> peculiarities;
    private final List<? extends Version> versions;

    private <T extends Enum<T>> LinuxDistribution(Class<T> versionClazz, Peculiarity ... peculiarities) {
        this.peculiarities = HasPecularities.asList((Peculiarity[])peculiarities);
        this.versions = Enums.valuesAsList(versionClazz);
    }

    public List<Peculiarity> pecularities() {
        return this.peculiarities;
    }

    public List<? extends Version> versions() {
        return this.versions;
    }
}

