/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.MongoCmdOptions;
import de.flapdoodle.embed.mongo.config.MongoCommonConfig;
import de.flapdoodle.embed.mongo.config.MongoShellConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.Timeout;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.SupportConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import org.immutables.value.Generated;

@Generated(from="MongoShellConfig", generator="Immutables")
public final class ImmutableMongoShellConfig
implements MongoShellConfig {
    private final Long stopTimeoutInMillis;
    private final IFeatureAwareVersion version;
    private final Timeout timeout;
    private final Net net;
    private final MongoCmdOptions cmdOptions;
    private final String password;
    private final String userName;
    private final List<String> scriptParameters;
    private final String scriptName;
    private final String dbName;
    private final String pidFile;
    private final SupportConfig supportConfig;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMongoShellConfig(Builder builder) {
        this.stopTimeoutInMillis = builder.stopTimeoutInMillis;
        this.version = builder.version;
        this.scriptParameters = ImmutableMongoShellConfig.createUnmodifiableList(true, builder.scriptParameters);
        this.scriptName = builder.scriptName;
        this.dbName = builder.dbName;
        if (builder.timeout != null) {
            this.initShim.timeout(builder.timeout);
        }
        if (builder.net != null) {
            this.initShim.net(builder.net);
        }
        if (builder.cmdOptions != null) {
            this.initShim.cmdOptions(builder.cmdOptions);
        }
        if (builder.password != null) {
            this.initShim.password(builder.password);
        }
        if (builder.userName != null) {
            this.initShim.userName(builder.userName);
        }
        if (builder.pidFile != null) {
            this.initShim.pidFile(builder.pidFile);
        }
        if (builder.supportConfig != null) {
            this.initShim.supportConfig(builder.supportConfig);
        }
        this.timeout = this.initShim.timeout();
        this.net = this.initShim.net();
        this.cmdOptions = this.initShim.cmdOptions();
        this.password = this.initShim.password();
        this.userName = this.initShim.userName();
        this.pidFile = this.initShim.pidFile();
        this.supportConfig = this.initShim.supportConfig();
        this.initShim = null;
    }

    private ImmutableMongoShellConfig(Long stopTimeoutInMillis, IFeatureAwareVersion version, Timeout timeout, Net net, MongoCmdOptions cmdOptions, String password, String userName, List<String> scriptParameters, String scriptName, String dbName, String pidFile, SupportConfig supportConfig) {
        this.stopTimeoutInMillis = stopTimeoutInMillis;
        this.version = version;
        this.timeout = timeout;
        this.net = net;
        this.cmdOptions = cmdOptions;
        this.password = password;
        this.userName = userName;
        this.scriptParameters = scriptParameters;
        this.scriptName = scriptName;
        this.dbName = dbName;
        this.pidFile = pidFile;
        this.supportConfig = supportConfig;
        this.initShim = null;
    }

    private Timeout timeoutInitialize() {
        return MongoShellConfig.super.timeout();
    }

    private Net netInitialize() {
        return MongoShellConfig.super.net();
    }

    private MongoCmdOptions cmdOptionsInitialize() {
        return MongoShellConfig.super.cmdOptions();
    }

    private String passwordInitialize() {
        return MongoShellConfig.super.password();
    }

    private String userNameInitialize() {
        return MongoShellConfig.super.userName();
    }

    private String pidFileInitialize() {
        return MongoShellConfig.super.pidFile();
    }

    private SupportConfig supportConfigInitialize() {
        return MongoShellConfig.super.supportConfig();
    }

    public OptionalLong stopTimeoutInMillis() {
        return this.stopTimeoutInMillis != null ? OptionalLong.of(this.stopTimeoutInMillis) : OptionalLong.empty();
    }

    @Override
    public IFeatureAwareVersion version() {
        return this.version;
    }

    @Override
    public Timeout timeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.timeout() : this.timeout;
    }

    @Override
    public Net net() {
        InitShim shim = this.initShim;
        return shim != null ? shim.net() : this.net;
    }

    @Override
    public MongoCmdOptions cmdOptions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cmdOptions() : this.cmdOptions;
    }

    @Override
    public String password() {
        InitShim shim = this.initShim;
        return shim != null ? shim.password() : this.password;
    }

    @Override
    public String userName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.userName() : this.userName;
    }

    @Override
    public List<String> getScriptParameters() {
        return this.scriptParameters;
    }

    @Override
    public String getScriptName() {
        return this.scriptName;
    }

    @Override
    public String getDbName() {
        return this.dbName;
    }

    @Override
    public String pidFile() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pidFile() : this.pidFile;
    }

    @Override
    public SupportConfig supportConfig() {
        InitShim shim = this.initShim;
        return shim != null ? shim.supportConfig() : this.supportConfig;
    }

    public final ImmutableMongoShellConfig withStopTimeoutInMillis(long value) {
        Long newValue = value;
        if (Objects.equals(this.stopTimeoutInMillis, newValue)) {
            return this;
        }
        return new ImmutableMongoShellConfig(newValue, this.version, this.timeout, this.net, this.cmdOptions, this.password, this.userName, this.scriptParameters, this.scriptName, this.dbName, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongoShellConfig withStopTimeoutInMillis(OptionalLong optional) {
        Long value;
        Long l = value = optional.isPresent() ? Long.valueOf(optional.getAsLong()) : null;
        if (Objects.equals(this.stopTimeoutInMillis, value)) {
            return this;
        }
        return new ImmutableMongoShellConfig(value, this.version, this.timeout, this.net, this.cmdOptions, this.password, this.userName, this.scriptParameters, this.scriptName, this.dbName, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongoShellConfig withVersion(IFeatureAwareVersion value) {
        if (this.version == value) {
            return this;
        }
        IFeatureAwareVersion newValue = Objects.requireNonNull(value, "version");
        return new ImmutableMongoShellConfig(this.stopTimeoutInMillis, newValue, this.timeout, this.net, this.cmdOptions, this.password, this.userName, this.scriptParameters, this.scriptName, this.dbName, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongoShellConfig withTimeout(Timeout value) {
        if (this.timeout == value) {
            return this;
        }
        Timeout newValue = Objects.requireNonNull(value, "timeout");
        return new ImmutableMongoShellConfig(this.stopTimeoutInMillis, this.version, newValue, this.net, this.cmdOptions, this.password, this.userName, this.scriptParameters, this.scriptName, this.dbName, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongoShellConfig withNet(Net value) {
        if (this.net == value) {
            return this;
        }
        Net newValue = Objects.requireNonNull(value, "net");
        return new ImmutableMongoShellConfig(this.stopTimeoutInMillis, this.version, this.timeout, newValue, this.cmdOptions, this.password, this.userName, this.scriptParameters, this.scriptName, this.dbName, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongoShellConfig withCmdOptions(MongoCmdOptions value) {
        if (this.cmdOptions == value) {
            return this;
        }
        MongoCmdOptions newValue = Objects.requireNonNull(value, "cmdOptions");
        return new ImmutableMongoShellConfig(this.stopTimeoutInMillis, this.version, this.timeout, this.net, newValue, this.password, this.userName, this.scriptParameters, this.scriptName, this.dbName, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongoShellConfig withPassword(String value) {
        String newValue = Objects.requireNonNull(value, "password");
        if (this.password.equals(newValue)) {
            return this;
        }
        return new ImmutableMongoShellConfig(this.stopTimeoutInMillis, this.version, this.timeout, this.net, this.cmdOptions, newValue, this.userName, this.scriptParameters, this.scriptName, this.dbName, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongoShellConfig withUserName(String value) {
        String newValue = Objects.requireNonNull(value, "userName");
        if (this.userName.equals(newValue)) {
            return this;
        }
        return new ImmutableMongoShellConfig(this.stopTimeoutInMillis, this.version, this.timeout, this.net, this.cmdOptions, this.password, newValue, this.scriptParameters, this.scriptName, this.dbName, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongoShellConfig withScriptParameters(String ... elements) {
        List<String> newValue = ImmutableMongoShellConfig.createUnmodifiableList(false, ImmutableMongoShellConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMongoShellConfig(this.stopTimeoutInMillis, this.version, this.timeout, this.net, this.cmdOptions, this.password, this.userName, newValue, this.scriptName, this.dbName, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongoShellConfig withScriptParameters(Iterable<String> elements) {
        if (this.scriptParameters == elements) {
            return this;
        }
        List<String> newValue = ImmutableMongoShellConfig.createUnmodifiableList(false, ImmutableMongoShellConfig.createSafeList(elements, true, false));
        return new ImmutableMongoShellConfig(this.stopTimeoutInMillis, this.version, this.timeout, this.net, this.cmdOptions, this.password, this.userName, newValue, this.scriptName, this.dbName, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongoShellConfig withScriptName(String value) {
        String newValue = Objects.requireNonNull(value, "scriptName");
        if (this.scriptName.equals(newValue)) {
            return this;
        }
        return new ImmutableMongoShellConfig(this.stopTimeoutInMillis, this.version, this.timeout, this.net, this.cmdOptions, this.password, this.userName, this.scriptParameters, newValue, this.dbName, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongoShellConfig withDbName(String value) {
        String newValue = Objects.requireNonNull(value, "dbName");
        if (this.dbName.equals(newValue)) {
            return this;
        }
        return new ImmutableMongoShellConfig(this.stopTimeoutInMillis, this.version, this.timeout, this.net, this.cmdOptions, this.password, this.userName, this.scriptParameters, this.scriptName, newValue, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongoShellConfig withPidFile(String value) {
        String newValue = Objects.requireNonNull(value, "pidFile");
        if (this.pidFile.equals(newValue)) {
            return this;
        }
        return new ImmutableMongoShellConfig(this.stopTimeoutInMillis, this.version, this.timeout, this.net, this.cmdOptions, this.password, this.userName, this.scriptParameters, this.scriptName, this.dbName, newValue, this.supportConfig);
    }

    public final ImmutableMongoShellConfig withSupportConfig(SupportConfig value) {
        if (this.supportConfig == value) {
            return this;
        }
        SupportConfig newValue = Objects.requireNonNull(value, "supportConfig");
        return new ImmutableMongoShellConfig(this.stopTimeoutInMillis, this.version, this.timeout, this.net, this.cmdOptions, this.password, this.userName, this.scriptParameters, this.scriptName, this.dbName, this.pidFile, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoShellConfig && this.equalTo((ImmutableMongoShellConfig)another);
    }

    private boolean equalTo(ImmutableMongoShellConfig another) {
        return Objects.equals(this.stopTimeoutInMillis, another.stopTimeoutInMillis) && this.version.equals(another.version) && this.timeout.equals(another.timeout) && this.net.equals(another.net) && this.cmdOptions.equals(another.cmdOptions) && this.password.equals(another.password) && this.userName.equals(another.userName) && this.scriptParameters.equals(another.scriptParameters) && this.scriptName.equals(another.scriptName) && this.dbName.equals(another.dbName) && this.pidFile.equals(another.pidFile) && this.supportConfig.equals(another.supportConfig);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.stopTimeoutInMillis);
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.timeout.hashCode();
        h += (h << 5) + this.net.hashCode();
        h += (h << 5) + this.cmdOptions.hashCode();
        h += (h << 5) + this.password.hashCode();
        h += (h << 5) + this.userName.hashCode();
        h += (h << 5) + this.scriptParameters.hashCode();
        h += (h << 5) + this.scriptName.hashCode();
        h += (h << 5) + this.dbName.hashCode();
        h += (h << 5) + this.pidFile.hashCode();
        h += (h << 5) + this.supportConfig.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MongoShellConfig{");
        if (this.stopTimeoutInMillis != null) {
            builder.append("stopTimeoutInMillis=").append(this.stopTimeoutInMillis);
        }
        if (builder.length() > 17) {
            builder.append(", ");
        }
        builder.append("version=").append(this.version);
        builder.append(", ");
        builder.append("timeout=").append(this.timeout);
        builder.append(", ");
        builder.append("net=").append(this.net);
        builder.append(", ");
        builder.append("cmdOptions=").append(this.cmdOptions);
        builder.append(", ");
        builder.append("password=").append(this.password);
        builder.append(", ");
        builder.append("userName=").append(this.userName);
        builder.append(", ");
        builder.append("scriptParameters=").append(this.scriptParameters);
        builder.append(", ");
        builder.append("scriptName=").append(this.scriptName);
        builder.append(", ");
        builder.append("dbName=").append(this.dbName);
        builder.append(", ");
        builder.append("pidFile=").append(this.pidFile);
        builder.append(", ");
        builder.append("supportConfig=").append(this.supportConfig);
        return builder.append("}").toString();
    }

    public static ImmutableMongoShellConfig copyOf(MongoShellConfig instance) {
        if (instance instanceof ImmutableMongoShellConfig) {
            return (ImmutableMongoShellConfig)instance;
        }
        return ImmutableMongoShellConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="MongoShellConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private static final long INIT_BIT_SCRIPT_NAME = 2L;
        private static final long INIT_BIT_DB_NAME = 4L;
        private long initBits = 7L;
        private Long stopTimeoutInMillis;
        private IFeatureAwareVersion version;
        private Timeout timeout;
        private Net net;
        private MongoCmdOptions cmdOptions;
        private String password;
        private String userName;
        private List<String> scriptParameters = new ArrayList<String>();
        private String scriptName;
        private String dbName;
        private String pidFile;
        private SupportConfig supportConfig;

        private Builder() {
        }

        public final Builder from(MongoShellConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MongoCommonConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ExecutableProcessConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MongoCommonConfig instance;
            long bits = 0L;
            if (object instanceof MongoShellConfig) {
                instance = (MongoShellConfig)object;
                this.addAllScriptParameters(instance.getScriptParameters());
                this.scriptName(instance.getScriptName());
                if ((bits & 1L) == 0L) {
                    this.supportConfig(instance.supportConfig());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.version(instance.version());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.pidFile(instance.pidFile());
                    bits |= 4L;
                }
                this.dbName(instance.getDbName());
            }
            if (object instanceof MongoCommonConfig) {
                instance = (MongoCommonConfig)object;
                this.password(instance.password());
                this.cmdOptions(instance.cmdOptions());
                this.net(instance.net());
                this.userName(instance.userName());
                if ((bits & 2L) == 0L) {
                    this.version(instance.version());
                    bits |= 2L;
                }
                this.timeout(instance.timeout());
                if ((bits & 4L) == 0L) {
                    this.pidFile(instance.pidFile());
                    bits |= 4L;
                }
            }
            if (object instanceof ExecutableProcessConfig) {
                OptionalLong stopTimeoutInMillisOptional;
                instance = (ExecutableProcessConfig)object;
                if ((bits & 1L) == 0L) {
                    this.supportConfig(instance.supportConfig());
                    bits |= 1L;
                }
                if ((stopTimeoutInMillisOptional = instance.stopTimeoutInMillis()).isPresent()) {
                    this.stopTimeoutInMillis(stopTimeoutInMillisOptional);
                }
            }
        }

        public final Builder stopTimeoutInMillis(long stopTimeoutInMillis) {
            this.stopTimeoutInMillis = stopTimeoutInMillis;
            return this;
        }

        public final Builder stopTimeoutInMillis(OptionalLong stopTimeoutInMillis) {
            this.stopTimeoutInMillis = stopTimeoutInMillis.isPresent() ? Long.valueOf(stopTimeoutInMillis.getAsLong()) : null;
            return this;
        }

        public final Builder version(IFeatureAwareVersion version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder timeout(Timeout timeout) {
            this.timeout = Objects.requireNonNull(timeout, "timeout");
            return this;
        }

        public final Builder net(Net net) {
            this.net = Objects.requireNonNull(net, "net");
            return this;
        }

        public final Builder cmdOptions(MongoCmdOptions cmdOptions) {
            this.cmdOptions = Objects.requireNonNull(cmdOptions, "cmdOptions");
            return this;
        }

        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            return this;
        }

        public final Builder userName(String userName) {
            this.userName = Objects.requireNonNull(userName, "userName");
            return this;
        }

        public final Builder addScriptParameters(String element) {
            this.scriptParameters.add(Objects.requireNonNull(element, "scriptParameters element"));
            return this;
        }

        public final Builder addScriptParameters(String ... elements) {
            for (String element : elements) {
                this.scriptParameters.add(Objects.requireNonNull(element, "scriptParameters element"));
            }
            return this;
        }

        public final Builder scriptParameters(Iterable<String> elements) {
            this.scriptParameters.clear();
            return this.addAllScriptParameters(elements);
        }

        public final Builder addAllScriptParameters(Iterable<String> elements) {
            for (String element : elements) {
                this.scriptParameters.add(Objects.requireNonNull(element, "scriptParameters element"));
            }
            return this;
        }

        public final Builder scriptName(String scriptName) {
            this.scriptName = Objects.requireNonNull(scriptName, "scriptName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder dbName(String dbName) {
            this.dbName = Objects.requireNonNull(dbName, "dbName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder pidFile(String pidFile) {
            this.pidFile = Objects.requireNonNull(pidFile, "pidFile");
            return this;
        }

        public final Builder supportConfig(SupportConfig supportConfig) {
            this.supportConfig = Objects.requireNonNull(supportConfig, "supportConfig");
            return this;
        }

        public ImmutableMongoShellConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMongoShellConfig(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scriptName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("dbName");
            }
            return "Cannot build MongoShellConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="MongoShellConfig", generator="Immutables")
    private final class InitShim {
        private byte timeoutBuildStage = 0;
        private Timeout timeout;
        private byte netBuildStage = 0;
        private Net net;
        private byte cmdOptionsBuildStage = 0;
        private MongoCmdOptions cmdOptions;
        private byte passwordBuildStage = 0;
        private String password;
        private byte userNameBuildStage = 0;
        private String userName;
        private byte pidFileBuildStage = 0;
        private String pidFile;
        private byte supportConfigBuildStage = 0;
        private SupportConfig supportConfig;

        private InitShim() {
        }

        Timeout timeout() {
            if (this.timeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.timeoutBuildStage == 0) {
                this.timeoutBuildStage = (byte)-1;
                this.timeout = Objects.requireNonNull(ImmutableMongoShellConfig.this.timeoutInitialize(), "timeout");
                this.timeoutBuildStage = 1;
            }
            return this.timeout;
        }

        void timeout(Timeout timeout) {
            this.timeout = timeout;
            this.timeoutBuildStage = 1;
        }

        Net net() {
            if (this.netBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.netBuildStage == 0) {
                this.netBuildStage = (byte)-1;
                this.net = Objects.requireNonNull(ImmutableMongoShellConfig.this.netInitialize(), "net");
                this.netBuildStage = 1;
            }
            return this.net;
        }

        void net(Net net) {
            this.net = net;
            this.netBuildStage = 1;
        }

        MongoCmdOptions cmdOptions() {
            if (this.cmdOptionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cmdOptionsBuildStage == 0) {
                this.cmdOptionsBuildStage = (byte)-1;
                this.cmdOptions = Objects.requireNonNull(ImmutableMongoShellConfig.this.cmdOptionsInitialize(), "cmdOptions");
                this.cmdOptionsBuildStage = 1;
            }
            return this.cmdOptions;
        }

        void cmdOptions(MongoCmdOptions cmdOptions) {
            this.cmdOptions = cmdOptions;
            this.cmdOptionsBuildStage = 1;
        }

        String password() {
            if (this.passwordBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.passwordBuildStage == 0) {
                this.passwordBuildStage = (byte)-1;
                this.password = Objects.requireNonNull(ImmutableMongoShellConfig.this.passwordInitialize(), "password");
                this.passwordBuildStage = 1;
            }
            return this.password;
        }

        void password(String password) {
            this.password = password;
            this.passwordBuildStage = 1;
        }

        String userName() {
            if (this.userNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.userNameBuildStage == 0) {
                this.userNameBuildStage = (byte)-1;
                this.userName = Objects.requireNonNull(ImmutableMongoShellConfig.this.userNameInitialize(), "userName");
                this.userNameBuildStage = 1;
            }
            return this.userName;
        }

        void userName(String userName) {
            this.userName = userName;
            this.userNameBuildStage = 1;
        }

        String pidFile() {
            if (this.pidFileBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pidFileBuildStage == 0) {
                this.pidFileBuildStage = (byte)-1;
                this.pidFile = Objects.requireNonNull(ImmutableMongoShellConfig.this.pidFileInitialize(), "pidFile");
                this.pidFileBuildStage = 1;
            }
            return this.pidFile;
        }

        void pidFile(String pidFile) {
            this.pidFile = pidFile;
            this.pidFileBuildStage = 1;
        }

        SupportConfig supportConfig() {
            if (this.supportConfigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.supportConfigBuildStage == 0) {
                this.supportConfigBuildStage = (byte)-1;
                this.supportConfig = Objects.requireNonNull(ImmutableMongoShellConfig.this.supportConfigInitialize(), "supportConfig");
                this.supportConfigBuildStage = 1;
            }
            return this.supportConfig;
        }

        void supportConfig(SupportConfig supportConfig) {
            this.supportConfig = supportConfig;
            this.supportConfigBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.timeoutBuildStage == -1) {
                attributes.add("timeout");
            }
            if (this.netBuildStage == -1) {
                attributes.add("net");
            }
            if (this.cmdOptionsBuildStage == -1) {
                attributes.add("cmdOptions");
            }
            if (this.passwordBuildStage == -1) {
                attributes.add("password");
            }
            if (this.userNameBuildStage == -1) {
                attributes.add("userName");
            }
            if (this.pidFileBuildStage == -1) {
                attributes.add("pidFile");
            }
            if (this.supportConfigBuildStage == -1) {
                attributes.add("supportConfig");
            }
            return "Cannot build MongoShellConfig, attribute initializers form cycle " + attributes;
        }
    }
}

