package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UrlTemplatePackageResolver}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUrlTemplatePackageResolver.builder()}.
 */
@Generated(from = "UrlTemplatePackageResolver", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableUrlTemplatePackageResolver
    extends UrlTemplatePackageResolver {
  private final ArchiveType archiveType;
  private final FileSet fileSet;
  private final String urlTemplate;

  private ImmutableUrlTemplatePackageResolver(
      ArchiveType archiveType,
      FileSet fileSet,
      String urlTemplate) {
    this.archiveType = archiveType;
    this.fileSet = fileSet;
    this.urlTemplate = urlTemplate;
  }

  /**
   * @return The value of the {@code archiveType} attribute
   */
  @Override
  protected ArchiveType archiveType() {
    return archiveType;
  }

  /**
   * @return The value of the {@code fileSet} attribute
   */
  @Override
  protected FileSet fileSet() {
    return fileSet;
  }

  /**
   * @return The value of the {@code urlTemplate} attribute
   */
  @Override
  protected String urlTemplate() {
    return urlTemplate;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UrlTemplatePackageResolver#archiveType() archiveType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for archiveType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUrlTemplatePackageResolver withArchiveType(ArchiveType value) {
    if (this.archiveType == value) return this;
    ArchiveType newValue = Objects.requireNonNull(value, "archiveType");
    if (this.archiveType.equals(newValue)) return this;
    return new ImmutableUrlTemplatePackageResolver(newValue, this.fileSet, this.urlTemplate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UrlTemplatePackageResolver#fileSet() fileSet} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fileSet
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUrlTemplatePackageResolver withFileSet(FileSet value) {
    if (this.fileSet == value) return this;
    FileSet newValue = Objects.requireNonNull(value, "fileSet");
    return new ImmutableUrlTemplatePackageResolver(this.archiveType, newValue, this.urlTemplate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UrlTemplatePackageResolver#urlTemplate() urlTemplate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for urlTemplate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUrlTemplatePackageResolver withUrlTemplate(String value) {
    String newValue = Objects.requireNonNull(value, "urlTemplate");
    if (this.urlTemplate.equals(newValue)) return this;
    return new ImmutableUrlTemplatePackageResolver(this.archiveType, this.fileSet, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUrlTemplatePackageResolver} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUrlTemplatePackageResolver
        && equalTo((ImmutableUrlTemplatePackageResolver) another);
  }

  private boolean equalTo(ImmutableUrlTemplatePackageResolver another) {
    return archiveType.equals(another.archiveType)
        && fileSet.equals(another.fileSet)
        && urlTemplate.equals(another.urlTemplate);
  }

  /**
   * Computes a hash code from attributes: {@code archiveType}, {@code fileSet}, {@code urlTemplate}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + archiveType.hashCode();
    h += (h << 5) + fileSet.hashCode();
    h += (h << 5) + urlTemplate.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UrlTemplatePackageResolver} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UrlTemplatePackageResolver{"
        + "archiveType=" + archiveType
        + ", fileSet=" + fileSet
        + ", urlTemplate=" + urlTemplate
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link UrlTemplatePackageResolver} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UrlTemplatePackageResolver instance
   */
  public static ImmutableUrlTemplatePackageResolver copyOf(UrlTemplatePackageResolver instance) {
    if (instance instanceof ImmutableUrlTemplatePackageResolver) {
      return (ImmutableUrlTemplatePackageResolver) instance;
    }
    return ImmutableUrlTemplatePackageResolver.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUrlTemplatePackageResolver ImmutableUrlTemplatePackageResolver}.
   * <pre>
   * ImmutableUrlTemplatePackageResolver.builder()
   *    .archiveType(de.flapdoodle.embed.process.distribution.ArchiveType) // required {@link UrlTemplatePackageResolver#archiveType() archiveType}
   *    .fileSet(de.flapdoodle.embed.process.config.store.FileSet) // required {@link UrlTemplatePackageResolver#fileSet() fileSet}
   *    .urlTemplate(String) // required {@link UrlTemplatePackageResolver#urlTemplate() urlTemplate}
   *    .build();
   * </pre>
   * @return A new ImmutableUrlTemplatePackageResolver builder
   */
  public static ImmutableUrlTemplatePackageResolver.Builder builder() {
    return new ImmutableUrlTemplatePackageResolver.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUrlTemplatePackageResolver ImmutableUrlTemplatePackageResolver}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UrlTemplatePackageResolver", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ARCHIVE_TYPE = 0x1L;
    private static final long INIT_BIT_FILE_SET = 0x2L;
    private static final long INIT_BIT_URL_TEMPLATE = 0x4L;
    private long initBits = 0x7L;

    private ArchiveType archiveType;
    private FileSet fileSet;
    private String urlTemplate;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UrlTemplatePackageResolver} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UrlTemplatePackageResolver instance) {
      Objects.requireNonNull(instance, "instance");
      archiveType(instance.archiveType());
      fileSet(instance.fileSet());
      urlTemplate(instance.urlTemplate());
      return this;
    }

    /**
     * Initializes the value for the {@link UrlTemplatePackageResolver#archiveType() archiveType} attribute.
     * @param archiveType The value for archiveType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder archiveType(ArchiveType archiveType) {
      this.archiveType = Objects.requireNonNull(archiveType, "archiveType");
      initBits &= ~INIT_BIT_ARCHIVE_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link UrlTemplatePackageResolver#fileSet() fileSet} attribute.
     * @param fileSet The value for fileSet 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder fileSet(FileSet fileSet) {
      this.fileSet = Objects.requireNonNull(fileSet, "fileSet");
      initBits &= ~INIT_BIT_FILE_SET;
      return this;
    }

    /**
     * Initializes the value for the {@link UrlTemplatePackageResolver#urlTemplate() urlTemplate} attribute.
     * @param urlTemplate The value for urlTemplate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder urlTemplate(String urlTemplate) {
      this.urlTemplate = Objects.requireNonNull(urlTemplate, "urlTemplate");
      initBits &= ~INIT_BIT_URL_TEMPLATE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUrlTemplatePackageResolver ImmutableUrlTemplatePackageResolver}.
     * @return An immutable instance of UrlTemplatePackageResolver
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUrlTemplatePackageResolver build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUrlTemplatePackageResolver(archiveType, fileSet, urlTemplate);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ARCHIVE_TYPE) != 0) attributes.add("archiveType");
      if ((initBits & INIT_BIT_FILE_SET) != 0) attributes.add("fileSet");
      if ((initBits & INIT_BIT_URL_TEMPLATE) != 0) attributes.add("urlTemplate");
      return "Cannot build UrlTemplatePackageResolver, some of required attributes are not set " + attributes;
    }
  }
}
