/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.client;

import com.mongodb.MongoCredential;
import de.flapdoodle.embed.mongo.client.MongoClientAction;
import de.flapdoodle.embed.mongo.commands.ServerAddress;
import de.flapdoodle.embed.mongo.transitions.RunningMongodProcess;
import java.io.Closeable;
import java.io.IOException;
import org.bson.Document;

public abstract class ExecuteMongoClientAction<C extends Closeable> {
    public void execute(RunningMongodProcess runningMongodProcess, MongoClientAction action) {
        try (Closeable client = action.credentials().map(c -> this.client(runningMongodProcess.getServerAddress(), MongoCredential.createCredential((String)c.username(), (String)c.database(), (char[])c.password().toCharArray()))).orElseGet(() -> this.client(runningMongodProcess.getServerAddress()));){
            action.onResult().accept(this.resultOfAction(client, action.action()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (RuntimeException rx) {
            action.onError().accept(rx);
        }
    }

    protected abstract C client(ServerAddress var1);

    protected abstract C client(ServerAddress var1, MongoCredential var2);

    protected abstract Document resultOfAction(C var1, MongoClientAction.Action var2);
}

