/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.client;

import de.flapdoodle.embed.mongo.client.UsernamePassword;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public final class ImmutableUsernamePassword
implements UsernamePassword {
    private final String name;
    private final char[] password;

    private ImmutableUsernamePassword(String name, char[] password) {
        this.name = Objects.requireNonNull(name, "name");
        this.password = (char[])password.clone();
    }

    private ImmutableUsernamePassword(ImmutableUsernamePassword original, String name, char[] password) {
        this.name = name;
        this.password = password;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public char[] password() {
        return (char[])this.password.clone();
    }

    public final ImmutableUsernamePassword withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableUsernamePassword(this, newValue, this.password);
    }

    public final ImmutableUsernamePassword withPassword(char ... elements) {
        char[] newValue = (char[])elements.clone();
        return new ImmutableUsernamePassword(this, this.name, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUsernamePassword && this.equalTo(0, (ImmutableUsernamePassword)another);
    }

    private boolean equalTo(int synthetic, ImmutableUsernamePassword another) {
        return this.name.equals(another.name) && Arrays.equals(this.password, another.password);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Arrays.hashCode(this.password);
        return h;
    }

    public String toString() {
        return "UsernamePassword{name=" + this.name + ", password=" + Arrays.toString(this.password) + "}";
    }

    public static ImmutableUsernamePassword of(String name, char[] password) {
        return new ImmutableUsernamePassword(name, password);
    }

    public static ImmutableUsernamePassword copyOf(UsernamePassword instance) {
        if (instance instanceof ImmutableUsernamePassword) {
            return (ImmutableUsernamePassword)instance;
        }
        return ImmutableUsernamePassword.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_PASSWORD = 2L;
        private long initBits = 3L;
        private String name;
        private char[] password;

        private Builder() {
        }

        public final Builder from(UsernamePassword instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.password(instance.password());
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder password(char ... password) {
            this.password = (char[])password.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUsernamePassword build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUsernamePassword(null, this.name, this.password);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("password");
            }
            return "Cannot build UsernamePassword, some of required attributes are not set " + attributes;
        }
    }
}

