/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.transitions;

import de.flapdoodle.embed.mongo.packageresolver.Command;
import de.flapdoodle.embed.mongo.types.StartTimeout;
import de.flapdoodle.embed.process.config.SupportConfig;
import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.embed.process.types.Name;
import de.flapdoodle.embed.process.types.ProcessConfig;
import de.flapdoodle.embed.process.types.ProcessEnv;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.Transitions;
import de.flapdoodle.reverse.transitions.Derive;
import de.flapdoodle.reverse.transitions.ImmutableStart;
import de.flapdoodle.reverse.transitions.Start;
import java.util.Collections;
import org.immutables.value.Value;

public interface ProcessDefaults {
    @Value.Default
    default public ImmutableStart<ProcessConfig> processConfig() {
        return Start.to(ProcessConfig.class).initializedWith((Object)ProcessConfig.defaults()).withTransitionLabel("create default");
    }

    @Value.Default
    default public Transition<ProcessEnv> processEnv() {
        return Start.to(ProcessEnv.class).initializedWith((Object)ProcessEnv.of(Collections.emptyMap())).withTransitionLabel("create empty env");
    }

    @Value.Default
    default public Transition<StartTimeout> startTimeout() {
        return Start.to(StartTimeout.class).initializedWith((Object)StartTimeout.of(30000L)).withTransitionLabel("startTimeout=30000ms");
    }

    @Value.Default
    default public Transition<ProcessOutput> processOutput() {
        return Derive.given(Name.class).state(ProcessOutput.class).deriveBy(name -> ProcessOutput.namedConsole((String)name.value())).withTransitionLabel("create named console");
    }

    @Value.Default
    default public Transition<SupportConfig> supportConfig() {
        return Derive.given(Command.class).state(SupportConfig.class).deriveBy(c -> SupportConfig.builder().name(c.commandName()).messageOnException((clazz, ex) -> null).supportUrl("https://github.com/flapdoodle-oss/de.flapdoodle.embed.mongo/issues").build()).withTransitionLabel("create default");
    }

    @Value.Auxiliary
    default public Transitions processDefaults() {
        return Transitions.from((Transition[])new Transition[]{this.processConfig(), this.processEnv(), this.processOutput(), this.supportConfig(), this.startTimeout()});
    }
}

