/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo;

import de.flapdoodle.embedmongo.Files;
import de.flapdoodle.embedmongo.Paths;
import de.flapdoodle.embedmongo.config.RuntimeConfig;
import de.flapdoodle.embedmongo.distribution.Distribution;
import de.flapdoodle.embedmongo.output.IProgressListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class Downloader {
    private Downloader() {
    }

    public static String getDownloadUrl(RuntimeConfig runtime, Distribution distribution) {
        return runtime.getDownloadPath() + Paths.getPath(distribution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File download(RuntimeConfig runtime, Distribution distribution) throws IOException {
        File ret = Files.createTempFile("embedmongo-download", "." + (Object)((Object)Paths.getArchiveType(distribution)));
        if (ret.canWrite()) {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(ret));
            URL url = new URL(Downloader.getDownloadUrl(runtime, distribution));
            URLConnection openConnection = url.openConnection();
            openConnection.setConnectTimeout(10000);
            openConnection.setReadTimeout(10000);
            InputStream downloadStream = openConnection.getInputStream();
            int length = openConnection.getContentLength();
            IProgressListener progress = runtime.getProgressListener();
            try {
                BufferedInputStream bis = new BufferedInputStream(downloadStream);
                byte[] buf = new byte[512];
                int read = 0;
                int readCount = 0;
                while ((read = bis.read(buf)) != -1) {
                    bos.write(buf, 0, read);
                    progress.progress("Download", length != -1 ? (readCount += read) / length : 0);
                }
            }
            finally {
                downloadStream.close();
                bos.flush();
                bos.close();
            }
            progress.done("Download");
        }
        return ret;
    }
}

