/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.logging.Logger;

public class Files {
    private static final Logger _logger = Logger.getLogger(Files.class.getName());

    private Files() {
    }

    public static File createTempFile(String prefix, String postfix) throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File tempFile = new File(tempDir, prefix + "-" + UUID.randomUUID().toString() + postfix);
        if (!tempFile.createNewFile()) {
            throw new IOException("Could not create Tempfile: " + tempFile);
        }
        return tempFile;
    }

    public static File createTempDir(String prefix) throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File tempFile = new File(tempDir, prefix + "-" + UUID.randomUUID().toString());
        if (!tempFile.mkdir()) {
            throw new IOException("Could not create Tempdir: " + tempFile);
        }
        return tempFile;
    }

    public static boolean deleteDir(File dir) {
        if (dir.exists()) {
            for (File file : dir.listFiles()) {
                if (!(file.isFile() ? !file.delete() : !Files.deleteDir(file))) continue;
                return false;
            }
            return dir.delete();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream in, long size, File output) throws IOException {
        FileOutputStream out = new FileOutputStream(output);
        try {
            int read;
            byte[] buf = new byte[512];
            int left = buf.length;
            if ((long)left > size) {
                left = (int)size;
            }
            while ((read = in.read(buf, 0, left)) != -1) {
                out.write(buf, 0, read);
                if ((long)left <= (size -= (long)read)) continue;
                left = (int)size;
            }
        }
        finally {
            out.close();
        }
    }

    public static boolean moveFile(File source, File destination) {
        if (!source.renameTo(destination)) {
            try {
                Files.copyFile(source, destination);
                return source.delete();
            }
            catch (IOException iox) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File source, File destination) throws IOException {
        FileInputStream reader = null;
        FileOutputStream writer = null;
        try {
            int read;
            reader = new FileInputStream(source);
            writer = new FileOutputStream(destination);
            byte[] buf = new byte[512];
            while ((read = reader.read(buf)) != -1) {
                writer.write(buf, 0, read);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }
}

