/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo;

import de.flapdoodle.embedmongo.Files;
import de.flapdoodle.embedmongo.Paths;
import de.flapdoodle.embedmongo.config.RuntimeConfig;
import de.flapdoodle.embedmongo.distribution.Distribution;
import java.io.File;

public class LocalArtifactStore {
    public static boolean checkArtifact(RuntimeConfig runtime, Distribution distribution) {
        return LocalArtifactStore.getArtifact(runtime, distribution) != null;
    }

    public static boolean store(RuntimeConfig runtime, Distribution distribution, File download) {
        File dir = LocalArtifactStore.createOrGetBaseDir(runtime);
        File artifactFile = new File(dir, Paths.getPath(distribution));
        LocalArtifactStore.createOrCheckDir(artifactFile.getParentFile());
        if (!Files.moveFile(download, artifactFile)) {
            throw new IllegalArgumentException("Could not move " + download + " to " + artifactFile);
        }
        File checkFile = new File(dir, Paths.getPath(distribution));
        return checkFile.exists() & checkFile.isFile() & checkFile.canRead();
    }

    private static File createOrGetBaseDir(RuntimeConfig runtime) {
        File dir = new File(LocalArtifactStore.getPath(runtime));
        LocalArtifactStore.createOrCheckDir(dir);
        return dir;
    }

    private static void createOrCheckDir(File dir) {
        if (!dir.exists() && !dir.mkdir()) {
            throw new IllegalArgumentException("Could NOT create Directory " + dir);
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("" + dir + " is not a Directory");
        }
    }

    private static String getPath(RuntimeConfig runtime) {
        return System.getProperty("user.home") + "/" + runtime.getArtifactStorePath() + "/";
    }

    public static File getArtifact(RuntimeConfig runtime, Distribution distribution) {
        File dir = LocalArtifactStore.createOrGetBaseDir(runtime);
        File artifactFile = new File(dir, Paths.getPath(distribution));
        if (artifactFile.exists() && artifactFile.isFile()) {
            return artifactFile;
        }
        return null;
    }
}

