/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo;

import de.flapdoodle.embedmongo.Files;
import de.flapdoodle.embedmongo.config.MongodConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MongodProcess {
    private static final Logger _logger = Logger.getLogger(MongodProcess.class.getName());
    private final MongodConfig _config;
    private final File _mongodExecutable;
    private Process _process;
    private File _dbDir;
    boolean _stopped = false;

    public MongodProcess(MongodConfig config, File mongodExecutable) throws IOException {
        this._config = config;
        this._mongodExecutable = mongodExecutable;
        try {
            this._dbDir = Files.createTempDir("embedmongo-db");
            ProcessBuilder processBuilder = new ProcessBuilder(this.getCommandLine(mongodExecutable));
            processBuilder.redirectErrorStream();
            this._process = processBuilder.start();
            Runtime.getRuntime().addShutdownHook(new JobKiller());
            InputStream inputStream = this._process.getInputStream();
            InputStreamReader reader = new InputStreamReader(inputStream);
            if (!LogWatch.waitForStart(reader, "waiting for connections on port", "failed", 2000L)) {
                throw new IOException("Could not start mongod process");
            }
            ConsoleOutput consoleOutput = new ConsoleOutput(reader);
            consoleOutput.setDaemon(true);
            consoleOutput.start();
        }
        catch (IOException iox) {
            this.stop();
            throw iox;
        }
    }

    private List<String> getCommandLine(File mongodExecutable) {
        return Arrays.asList(this._mongodExecutable.getAbsolutePath(), "-v", "--port", "" + this._config.getPort(), "--dbpath", "" + this._dbDir.getAbsolutePath(), "--noprealloc");
    }

    public synchronized void stop() {
        if (!this._stopped) {
            if (this._process != null) {
                this._process.destroy();
            }
            if (!Files.deleteDir(this._dbDir)) {
                _logger.warning("Could not delete temp db dir: " + this._dbDir);
            }
            if (!this._mongodExecutable.delete()) {
                _logger.warning("Could not delete temp mongod exe: " + this._mongodExecutable);
            }
            this._stopped = true;
        }
    }

    static class ConsoleOutput
    extends Thread {
        private final InputStreamReader _reader;

        public ConsoleOutput(InputStreamReader reader) {
            this._reader = reader;
        }

        @Override
        public void run() {
            try {
                int read;
                char[] buf = new char[512];
                while ((read = this._reader.read(buf)) != -1) {
                    System.out.print(new String(buf, 0, read));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class LogWatch
    extends Thread {
        private final InputStreamReader _reader;
        private final StringBuilder _output = new StringBuilder();
        private final String _success;
        private final String _failure;
        private boolean _initWithSuccess = false;

        private LogWatch(InputStreamReader reader, String success, String failure) {
            this._reader = reader;
            this._success = success;
            this._failure = failure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int read;
                char[] buf = new char[512];
                while ((read = this._reader.read(buf)) != -1) {
                    String line = new String(buf, 0, read);
                    System.out.print((Object)line);
                    this._output.append((CharSequence)line);
                    if (this._output.indexOf(this._success) != -1) {
                        this._initWithSuccess = true;
                    } else {
                        if (this._output.indexOf(this._failure) == -1) continue;
                        this._initWithSuccess = false;
                    }
                    break;
                }
            }
            catch (IOException iox) {
                _logger.log(Level.SEVERE, "out", iox);
            }
            LogWatch logWatch = this;
            synchronized (logWatch) {
                this.notify();
            }
        }

        public boolean isInitWithSuccess() {
            return this._initWithSuccess;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean waitForStart(InputStreamReader reader, String success, String failed, long timeout) {
            LogWatch logWatch = new LogWatch(reader, success, failed);
            logWatch.start();
            LogWatch logWatch2 = logWatch;
            synchronized (logWatch2) {
                try {
                    logWatch.wait(timeout);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return logWatch.isInitWithSuccess();
        }
    }

    class JobKiller
    extends Thread {
        JobKiller() {
        }

        @Override
        public void run() {
            this.stop();
        }
    }
}

