/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo;

import de.flapdoodle.embedmongo.distribution.ArchiveType;
import de.flapdoodle.embedmongo.distribution.Distribution;
import java.util.regex.Pattern;

public class Paths {
    public static Pattern getMongodExecutablePattern(Distribution distribution) {
        return Pattern.compile(".*" + Paths.getMongodExecutable(distribution));
    }

    public static String getMongodExecutable(Distribution distribution) {
        String mongodPattern;
        switch (distribution.getPlatform()) {
            case Linux: {
                mongodPattern = "mongod";
                break;
            }
            case Windows: {
                mongodPattern = "mongod.exe";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + (Object)((Object)distribution.getPlatform()));
            }
        }
        return mongodPattern;
    }

    public static ArchiveType getArchiveType(Distribution distribution) {
        ArchiveType archiveType;
        switch (distribution.getPlatform()) {
            case Linux: {
                archiveType = ArchiveType.TGZ;
                break;
            }
            case Windows: {
                archiveType = ArchiveType.ZIP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + (Object)((Object)distribution.getPlatform()));
            }
        }
        return archiveType;
    }

    public static String getPath(Distribution distribution) {
        String sbitSize;
        String splatform;
        String sarchiveType;
        String sversion;
        switch (distribution.getVersion()) {
            case V1_6_5: {
                sversion = "1.6.5";
                break;
            }
            case V1_7_6: {
                sversion = "1.7.6";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Version " + (Object)((Object)distribution.getVersion()));
            }
        }
        ArchiveType archiveType = Paths.getArchiveType(distribution);
        switch (archiveType) {
            case TGZ: {
                sarchiveType = "tgz";
                break;
            }
            case ZIP: {
                sarchiveType = "zip";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ArchiveType " + (Object)((Object)archiveType));
            }
        }
        switch (distribution.getPlatform()) {
            case Linux: {
                splatform = "linux";
                break;
            }
            case Windows: {
                splatform = "win32";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + (Object)((Object)distribution.getPlatform()));
            }
        }
        block12 : switch (distribution.getBitsize()) {
            case B32: {
                switch (distribution.getPlatform()) {
                    case Linux: {
                        sbitSize = "i686";
                        break block12;
                    }
                    case Windows: {
                        sbitSize = "i386";
                        break block12;
                    }
                }
                throw new IllegalArgumentException("Unknown Platform " + (Object)((Object)distribution.getPlatform()));
            }
            case B64: {
                sbitSize = "x86_64";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown BitSize " + (Object)((Object)distribution.getBitsize()));
            }
        }
        return splatform + "/mongodb-" + splatform + "-" + sbitSize + "-" + sversion + "." + sarchiveType;
    }
}

