/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo.output;

import de.flapdoodle.embedmongo.output.IProgressListener;

public class ConsoleProgressListener
implements IProgressListener {
    private static final char BAR_DONE = '=';
    private static final char BAR_TODO = '-';
    static final int LINE_LEN = 80;
    static final char[] CLOCK = new char[]{'-', '\\', '|', '/'};
    int _lastPercent = -1;
    int _lastIdx = 0;

    @Override
    public void progress(String label, int percent) {
        if (percent < 0) {
            throw new IllegalArgumentException("Percent < 0: " + percent);
        }
        if (percent > 100) {
            throw new IllegalArgumentException("Percent > 100: " + percent);
        }
        if (this._lastPercent == percent) {
            ++this._lastIdx;
            if (this._lastIdx >= CLOCK.length) {
                this._lastIdx = 0;
            }
        } else {
            this._lastIdx = 0;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(label).append(" ");
        int lineLength = 80 - label.length() - 1;
        int percLength = percent * lineLength / 100;
        sb.append(ConsoleProgressListener.makeString('=', percLength));
        if (percent < 100) {
            sb.append(CLOCK[this._lastIdx]);
            sb.append(ConsoleProgressListener.makeString('-', lineLength - percLength));
        } else {
            sb.append('=');
        }
        sb.append("\r");
        this._lastPercent = percent;
        System.out.print(sb.toString());
    }

    @Override
    public void done(String label) {
        System.out.println(label + " DONE");
    }

    static String makeString(char c, int len) {
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }
}

