/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo;

import de.flapdoodle.embedmongo.MongodProcess;
import de.flapdoodle.embedmongo.config.MongodConfig;
import de.flapdoodle.embedmongo.distribution.Distribution;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class MongodExecutable {
    private static final Logger _logger = Logger.getLogger(MongodExecutable.class.getName());
    private final MongodConfig _mongodConfig;
    private final File _mongodExecutable;
    private boolean _stopped;
    private final Distribution _distribution;

    public MongodExecutable(Distribution distribution, MongodConfig mongodConfig, File mongodExecutable) {
        this._distribution = distribution;
        this._mongodConfig = mongodConfig;
        this._mongodExecutable = mongodExecutable;
        Runtime.getRuntime().addShutdownHook(new JobKiller());
    }

    public synchronized void cleanup() {
        if (!this._stopped) {
            if (this._mongodExecutable.exists() && !this._mongodExecutable.delete()) {
                _logger.warning("Could not delete temp mongod exe: " + this._mongodExecutable);
            }
            this._stopped = true;
        }
    }

    public File getFile() {
        return this._mongodExecutable;
    }

    public MongodProcess start() throws IOException {
        return new MongodProcess(this._distribution, this._mongodConfig, this);
    }

    class JobKiller
    extends Thread {
        JobKiller() {
        }

        @Override
        public void run() {
            MongodExecutable.this.cleanup();
        }
    }
}

