/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo;

import de.flapdoodle.embedmongo.Files;
import de.flapdoodle.embedmongo.MongodExecutable;
import de.flapdoodle.embedmongo.config.MongodConfig;
import de.flapdoodle.embedmongo.distribution.Distribution;
import de.flapdoodle.embedmongo.io.ConsoleOutput;
import de.flapdoodle.embedmongo.io.LogWatch;
import de.flapdoodle.embedmongo.runtime.NUMA;
import de.flapdoodle.embedmongo.runtime.ProcessControl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class MongodProcess {
    static final Logger _logger = Logger.getLogger(MongodProcess.class.getName());
    private final MongodConfig _config;
    private final MongodExecutable _mongodExecutable;
    private ProcessControl _process;
    private ConsoleOutput _consoleOutput;
    private File _dbDir;
    boolean _processKilled = false;
    boolean _stopped = false;

    public MongodProcess(Distribution distribution, MongodConfig config, MongodExecutable mongodExecutable) throws IOException {
        this._config = config;
        this._mongodExecutable = mongodExecutable;
        try {
            File dbDir;
            if (config.getDatabaseDir() != null) {
                dbDir = Files.createOrCheckDir(config.getDatabaseDir());
            } else {
                this._dbDir = dbDir = Files.createTempDir("embedmongo-db");
            }
            this._process = ProcessControl.fromCommandLine(this.enhanceCommandLinePlattformSpecific(distribution, MongodProcess.getCommandLine(this._config, this._mongodExecutable.getFile(), dbDir)));
            Runtime.getRuntime().addShutdownHook(new JobKiller());
            if (!LogWatch.waitForStart(this._process.getReader(), "waiting for connections on port", "failed", 20000L)) {
                throw new IOException("Could not start mongod process");
            }
            this._consoleOutput = new ConsoleOutput(this._process.getReader());
            this._consoleOutput.setDaemon(true);
            this._consoleOutput.start();
        }
        catch (IOException iox) {
            this.stop();
            throw iox;
        }
    }

    private static List<String> getCommandLine(MongodConfig config, File mongodExecutable, File dbDir) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(Arrays.asList(mongodExecutable.getAbsolutePath(), "-v", "--port", "" + config.getPort(), "--dbpath", "" + dbDir.getAbsolutePath(), "--noprealloc", "--nohttpinterface", "--smallfiles"));
        if (config.isIpv6()) {
            ret.add("--ipv6");
        }
        return ret;
    }

    private List<String> enhanceCommandLinePlattformSpecific(Distribution distribution, List<String> commands) {
        if (NUMA.isNUMA(distribution.getPlatform())) {
            switch (distribution.getPlatform()) {
                case Linux: {
                    ArrayList<String> ret = new ArrayList<String>();
                    ret.add("numactl");
                    ret.add("--interleave=all");
                    ret.addAll(commands);
                    return ret;
                }
            }
            _logger.warning("NUMA Plattform detected, but not supported.");
        }
        return commands;
    }

    public synchronized void stop() {
        if (!this._stopped) {
            if (this._process != null) {
                this._process.stop();
            }
            this.waitForProcessGotKilled();
            if (this._dbDir != null && !Files.forceDelete(this._dbDir)) {
                _logger.warning("Could not delete temp db dir: " + this._dbDir);
            }
            if (this._mongodExecutable.getFile() != null && !Files.forceDelete(this._mongodExecutable.getFile())) {
                this._stopped = true;
                _logger.warning("Could not delete mongod executable NOW: " + this._mongodExecutable.getFile());
            }
        }
    }

    private void waitForProcessGotKilled() {
        final Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    MongodProcess.this._process.waitFor();
                }
                catch (InterruptedException e) {
                    _logger.severe(e.getMessage());
                }
                finally {
                    MongodProcess.this._processKilled = true;
                    timer.cancel();
                }
            }
        }, 0L, 10L);
        int countDown = 100;
        while (!this._processKilled && countDown-- > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                _logger.severe(e.getMessage());
            }
        }
        if (!this._processKilled) {
            timer.cancel();
            throw new IllegalStateException("Couldn't kill mongod process!");
        }
    }

    class JobKiller
    extends Thread {
        JobKiller() {
        }

        @Override
        public void run() {
            MongodProcess.this.stop();
        }
    }
}

