/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo.io;

import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogWatch
extends Thread {
    private static final Logger _logger = Logger.getLogger(LogWatch.class.getName());
    private final Reader _reader;
    private final StringBuilder _output = new StringBuilder();
    private final String _success;
    private final String _failure;
    private boolean _initWithSuccess = false;

    private LogWatch(Reader reader, String success, String failure) {
        this._reader = reader;
        this._success = success;
        this._failure = failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int read;
            char[] buf = new char[512];
            while ((read = this._reader.read(buf)) != -1) {
                String line = new String(buf, 0, read);
                System.out.print((Object)line);
                System.out.flush();
                this._output.append((CharSequence)line);
                if (this._output.indexOf(this._success) != -1) {
                    this._initWithSuccess = true;
                } else {
                    if (this._output.indexOf(this._failure) == -1) continue;
                    this._initWithSuccess = false;
                }
                break;
            }
        }
        catch (IOException iox) {
            _logger.log(Level.SEVERE, "out", iox);
        }
        LogWatch logWatch = this;
        synchronized (logWatch) {
            this.notify();
        }
    }

    public boolean isInitWithSuccess() {
        return this._initWithSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForStart(Reader reader, String success, String failed, long timeout) {
        LogWatch logWatch = new LogWatch(reader, success, failed);
        logWatch.start();
        LogWatch logWatch2 = logWatch;
        synchronized (logWatch2) {
            try {
                logWatch.wait(timeout);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return logWatch.isInitWithSuccess();
    }
}

