/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo.runtime;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.logging.Logger;

public class ProcessControl {
    private static final Logger _logger = Logger.getLogger(ProcessControl.class.getName());
    private Process _process;
    private InputStreamReader _reader;

    public ProcessControl(Process process) {
        this._process = process;
        this._reader = new InputStreamReader(this._process.getInputStream());
    }

    public Reader getReader() {
        return this._reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this._process != null) {
            try {
                this._process.getErrorStream().close();
                this._process.getInputStream().close();
                this._process.getOutputStream().close();
            }
            catch (IOException e) {
                _logger.severe(e.getMessage());
            }
            finally {
                this._process.destroy();
            }
            this._reader = null;
        }
    }

    public int waitFor() throws InterruptedException {
        return this._process.waitFor();
    }

    public static ProcessControl fromCommandLine(List<String> commandLine) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        processBuilder.redirectErrorStream();
        return new ProcessControl(processBuilder.start());
    }
}

