/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo;

import de.flapdoodle.embedmongo.Files;
import de.flapdoodle.embedmongo.MongodExecutable;
import de.flapdoodle.embedmongo.collections.Collections;
import de.flapdoodle.embedmongo.config.MongodConfig;
import de.flapdoodle.embedmongo.distribution.Distribution;
import de.flapdoodle.embedmongo.distribution.Platform;
import de.flapdoodle.embedmongo.io.ConsoleOutput;
import de.flapdoodle.embedmongo.io.LogWatch;
import de.flapdoodle.embedmongo.runtime.MongodShutdown;
import de.flapdoodle.embedmongo.runtime.NUMA;
import de.flapdoodle.embedmongo.runtime.Network;
import de.flapdoodle.embedmongo.runtime.ProcessControl;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MongodProcess {
    static final Logger _logger = Logger.getLogger(MongodProcess.class.getName());
    private final MongodConfig _config;
    private final MongodExecutable _mongodExecutable;
    private ProcessControl _process;
    private int _mongodProcessId;
    private ConsoleOutput _consoleOutput;
    private File _dbDir;
    boolean _processKilled = false;
    boolean _stopped = false;
    private Distribution _distribution;

    public MongodProcess(Distribution distribution, MongodConfig config, MongodExecutable mongodExecutable) throws IOException {
        this._config = config;
        this._mongodExecutable = mongodExecutable;
        this._distribution = distribution;
        try {
            File dbDir;
            if (config.getDatabaseDir() != null) {
                dbDir = Files.createOrCheckDir(config.getDatabaseDir());
            } else {
                this._dbDir = dbDir = Files.createTempDir("embedmongo-db");
            }
            this._process = ProcessControl.fromCommandLine(this.enhanceCommandLinePlattformSpecific(distribution, MongodProcess.getCommandLine(this._config, this._mongodExecutable.getFile(), dbDir)));
            Runtime.getRuntime().addShutdownHook(new JobKiller());
            LogWatch logWatch = LogWatch.watch(this._process.getReader(), "waiting for connections on port", "failed", 20000L);
            if (!logWatch.isInitWithSuccess()) {
                throw new IOException("Could not start mongod process");
            }
            this._mongodProcessId = MongodProcess.getMongodProcessId(logWatch.getOutput(), -1);
            this._consoleOutput = new ConsoleOutput(this._process.getReader());
            this._consoleOutput.setDaemon(true);
            this._consoleOutput.start();
        }
        catch (IOException iox) {
            this.stop();
            throw iox;
        }
    }

    protected static int getMongodProcessId(String output, int defaultValue) {
        Pattern pattern = Pattern.compile("MongoDB starting : pid=([1234567890]+) port", 8);
        Matcher matcher = pattern.matcher(output);
        if (matcher.find()) {
            String value = matcher.group(1);
            return Integer.valueOf(value);
        }
        return defaultValue;
    }

    private static List<String> getCommandLine(MongodConfig config, File mongodExecutable, File dbDir) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(Arrays.asList(mongodExecutable.getAbsolutePath(), "-v", "--port", "" + config.getPort(), "--dbpath", "" + dbDir.getAbsolutePath(), "--noprealloc", "--nohttpinterface", "--smallfiles"));
        if (config.isIpv6()) {
            ret.add("--ipv6");
        }
        return ret;
    }

    private List<String> enhanceCommandLinePlattformSpecific(Distribution distribution, List<String> commands) {
        if (NUMA.isNUMA(distribution.getPlatform())) {
            switch (distribution.getPlatform()) {
                case Linux: {
                    ArrayList<String> ret = new ArrayList<String>();
                    ret.add("numactl");
                    ret.add("--interleave=all");
                    ret.addAll(commands);
                    return ret;
                }
            }
            _logger.warning("NUMA Plattform detected, but not supported.");
        }
        return commands;
    }

    public synchronized void stop() {
        if (!this._stopped) {
            if (!this.sendStopToMongoInstance()) {
                this.sendKillToMongodProcess();
            }
            if (this._process != null) {
                this._process.stop();
            }
            this.waitForProcessGotKilled();
            if (this._dbDir != null && !Files.forceDelete(this._dbDir)) {
                _logger.warning("Could not delete temp db dir: " + this._dbDir);
            }
            if (this._mongodExecutable.getFile() != null && !Files.forceDelete(this._mongodExecutable.getFile())) {
                this._stopped = true;
                _logger.warning("Could not delete mongod executable NOW: " + this._mongodExecutable.getFile());
            }
        }
    }

    private boolean sendStopToMongoInstance() {
        try {
            return MongodShutdown.sendShutdown(Network.getLocalHost(), this._config.getPort());
        }
        catch (UnknownHostException e) {
            _logger.log(Level.SEVERE, "sendStop", e);
            return false;
        }
    }

    private static boolean executeCommandLine(List<String> commandLine) {
        try {
            ProcessControl killProcess = ProcessControl.fromCommandLine(commandLine);
            Thread.sleep(100L);
            killProcess.stop();
            return true;
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "" + commandLine, e);
        }
        catch (InterruptedException e) {
            _logger.log(Level.SEVERE, "" + commandLine, e);
        }
        return false;
    }

    private boolean sendKillToMongodProcess() {
        if (this._mongodProcessId != -1) {
            ArrayList<String> commandLine = Collections.newArrayList("kill", "-2", "" + this._mongodProcessId);
            if (this._distribution.getPlatform() == Platform.Windows) {
                commandLine = Collections.newArrayList("taskkill", "/pid", "" + this._mongodProcessId);
            }
            return MongodProcess.executeCommandLine(commandLine);
        }
        return false;
    }

    private void waitForProcessGotKilled() {
        final Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    MongodProcess.this._process.waitFor();
                }
                catch (InterruptedException e) {
                    _logger.severe(e.getMessage());
                }
                finally {
                    MongodProcess.this._processKilled = true;
                    timer.cancel();
                }
            }
        }, 0L, 10L);
        int countDown = 100;
        while (!this._processKilled && countDown-- > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                _logger.severe(e.getMessage());
            }
        }
        if (!this._processKilled) {
            timer.cancel();
            throw new IllegalStateException("Couldn't kill mongod process!");
        }
    }

    class JobKiller
    extends Thread {
        JobKiller() {
        }

        @Override
        public void run() {
            MongodProcess.this.stop();
        }
    }
}

