/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo;

import de.flapdoodle.embedmongo.Files;
import de.flapdoodle.embedmongo.MongodExecutable;
import de.flapdoodle.embedmongo.config.MongodConfig;
import de.flapdoodle.embedmongo.distribution.Distribution;
import de.flapdoodle.embedmongo.io.ConsoleOutput;
import de.flapdoodle.embedmongo.io.LogWatch;
import de.flapdoodle.embedmongo.runtime.Mongod;
import de.flapdoodle.embedmongo.runtime.Network;
import de.flapdoodle.embedmongo.runtime.ProcessControl;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MongodProcess {
    static final Logger _logger = Logger.getLogger(MongodProcess.class.getName());
    private final MongodConfig _config;
    private final MongodExecutable _mongodExecutable;
    private ProcessControl _process;
    private int _mongodProcessId;
    private ConsoleOutput _consoleOutput;
    private File _dbDir;
    boolean _stopped = false;
    private Distribution _distribution;

    public MongodProcess(Distribution distribution, MongodConfig config, MongodExecutable mongodExecutable) throws IOException {
        this._config = config;
        this._mongodExecutable = mongodExecutable;
        this._distribution = distribution;
        try {
            File dbDir;
            if (config.getDatabaseDir() != null) {
                dbDir = Files.createOrCheckDir(config.getDatabaseDir());
            } else {
                this._dbDir = dbDir = Files.createTempDir("embedmongo-db");
            }
            this._process = ProcessControl.fromCommandLine(Mongod.enhanceCommandLinePlattformSpecific(distribution, Mongod.getCommandLine(this._config, this._mongodExecutable.getFile(), dbDir)));
            Runtime.getRuntime().addShutdownHook(new JobKiller());
            LogWatch logWatch = LogWatch.watch(this._process.getReader(), "waiting for connections on port", "failed", 20000L);
            if (!logWatch.isInitWithSuccess()) {
                throw new IOException("Could not start mongod process");
            }
            this._mongodProcessId = Mongod.getMongodProcessId(logWatch.getOutput(), -1);
            this._consoleOutput = new ConsoleOutput(this._process.getReader());
            this._consoleOutput.setDaemon(true);
            this._consoleOutput.start();
        }
        catch (IOException iox) {
            this.stop();
            throw iox;
        }
    }

    public synchronized void stop() {
        if (!this._stopped) {
            if (!this.sendKillToMongodProcess()) {
                this.sendStopToMongoInstance();
            }
            this._process.stop();
            if (this._dbDir != null && !Files.forceDelete(this._dbDir)) {
                _logger.warning("Could not delete temp db dir: " + this._dbDir);
            }
        }
    }

    private boolean sendStopToMongoInstance() {
        try {
            return Mongod.sendShutdown(Network.getLocalHost(), this._config.getPort());
        }
        catch (UnknownHostException e) {
            _logger.log(Level.SEVERE, "sendStop", e);
            return false;
        }
    }

    private boolean sendKillToMongodProcess() {
        if (this._mongodProcessId != -1) {
            return ProcessControl.killProcess(this._distribution.getPlatform(), this._mongodProcessId);
        }
        return false;
    }

    class JobKiller
    extends Thread {
        JobKiller() {
        }

        @Override
        public void run() {
            MongodProcess.this.stop();
        }
    }
}

