/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo.runtime;

import de.flapdoodle.embedmongo.collections.Collections;
import de.flapdoodle.embedmongo.distribution.Platform;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessControl {
    private static final Logger _logger = Logger.getLogger(ProcessControl.class.getName());
    private Process _process;
    private InputStreamReader _reader;

    public ProcessControl(Process process) {
        this._process = process;
        this._reader = new InputStreamReader(this._process.getInputStream());
    }

    public Reader getReader() {
        return this._reader;
    }

    public int stop() {
        this.closeIOAndDestroy();
        return this.waitForProcessGotKilled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeIOAndDestroy() {
        if (this._process != null) {
            try {
                this._process.getErrorStream().close();
                this._process.getInputStream().close();
                this._process.getOutputStream().close();
            }
            catch (IOException e) {
                _logger.severe(e.getMessage());
            }
            finally {
                this._process.destroy();
            }
            this._reader = null;
        }
    }

    private int waitForProcessGotKilled() {
        final ProcessState state = new ProcessState();
        final Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    state.returnCode = ProcessControl.this._process.waitFor();
                }
                catch (InterruptedException e) {
                    _logger.severe(e.getMessage());
                }
                finally {
                    state.killed = true;
                    timer.cancel();
                }
            }
        }, 0L, 10L);
        int countDown = 100;
        while (!state.killed && countDown-- > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                _logger.severe(e.getMessage());
            }
        }
        if (!state.killed) {
            timer.cancel();
            throw new IllegalStateException("Couldn't kill mongod process!");
        }
        return state.returnCode;
    }

    public static ProcessControl fromCommandLine(List<String> commandLine) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        processBuilder.redirectErrorStream();
        return new ProcessControl(processBuilder.start());
    }

    public static boolean executeCommandLine(List<String> commandLine) {
        boolean ret = false;
        try {
            ProcessControl killProcess = ProcessControl.fromCommandLine(commandLine);
            ret = killProcess.stop() == 0;
            return ret;
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "" + commandLine, e);
            return false;
        }
    }

    public static boolean killProcess(Platform platform, int pid) {
        ArrayList<String> commandLine = Collections.newArrayList("kill", "-2", "" + pid);
        if (platform == Platform.Windows) {
            commandLine = Collections.newArrayList("taskkill", "/pid", "" + pid);
        }
        return ProcessControl.executeCommandLine(commandLine);
    }

    static class ProcessState {
        protected int returnCode;
        boolean killed = false;

        ProcessState() {
        }
    }
}

