/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo.io;

import de.flapdoodle.embedmongo.io.IStreamProcessor;

public class StreamToLineProcessor
implements IStreamProcessor {
    private final IStreamProcessor _destination;
    StringBuilder _buffer = new StringBuilder();

    public StreamToLineProcessor(IStreamProcessor destination) {
        this._destination = destination;
    }

    @Override
    public void process(String block) {
        int newLineEnd = block.indexOf(10);
        if (newLineEnd == -1) {
            this._buffer.append(block);
        } else {
            this._buffer.append(block.substring(0, newLineEnd + 1));
            this._destination.process(this.getAndClearBuffer());
            do {
                int lastEnd = newLineEnd;
                if ((newLineEnd = block.indexOf(10, newLineEnd + 1)) != -1) {
                    this._destination.process(block.substring(lastEnd + 1, newLineEnd + 1));
                    continue;
                }
                this._buffer.append(block.substring(lastEnd + 1));
            } while (newLineEnd != -1);
        }
    }

    private String getAndClearBuffer() {
        String ret = this._buffer.toString();
        this._buffer.setLength(0);
        return ret;
    }

    @Override
    public void onProcessed() {
        if (this._buffer.length() > 0) {
            this._destination.process(this.getAndClearBuffer());
        }
        this._destination.onProcessed();
    }

    public static IStreamProcessor wrap(IStreamProcessor destination) {
        return new StreamToLineProcessor(destination);
    }
}

