/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo.runtime;

import de.flapdoodle.embedmongo.collections.Collections;
import de.flapdoodle.embedmongo.config.ProcessConfig;
import de.flapdoodle.embedmongo.distribution.Platform;
import de.flapdoodle.embedmongo.io.IStreamProcessor;
import de.flapdoodle.embedmongo.io.Processors;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessControl {
    private static final Logger _logger = Logger.getLogger(ProcessControl.class.getName());
    private Process _process;
    private InputStreamReader _reader;
    private InputStreamReader _error;
    private Integer _pid;

    public ProcessControl(Process process) {
        this._process = process;
        this._reader = new InputStreamReader(this._process.getInputStream());
        this._error = new InputStreamReader(this._process.getErrorStream());
        this._pid = this.getProcessID();
    }

    public Reader getReader() {
        return this._reader;
    }

    public InputStreamReader getError() {
        return this._error;
    }

    public int stop() {
        this.closeIOAndDestroy();
        return this.waitForProcessGotKilled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeIOAndDestroy() {
        if (this._process != null) {
            try {
                this._process.getErrorStream().close();
                this._process.getInputStream().close();
                this._process.getOutputStream().close();
            }
            catch (IOException e) {
                _logger.severe(e.getMessage());
            }
            finally {
                this._process.destroy();
            }
            this._reader = null;
        }
    }

    private int waitForProcessGotKilled() {
        final ProcessState state = new ProcessState();
        final Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    state.returnCode = ProcessControl.this._process.waitFor();
                }
                catch (InterruptedException e) {
                    _logger.severe(e.getMessage());
                }
                finally {
                    state.killed = true;
                    timer.cancel();
                }
            }
        }, 0L, 10L);
        int countDown = 100;
        while (!state.killed && countDown-- > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                _logger.severe(e.getMessage());
            }
        }
        if (!state.killed) {
            timer.cancel();
            String message = "\n\n----------------------------------------------------\nSomething bad happend. We couldn't kill mongod process, and tried a lot.\nIf you want this problem solved you can help us if you open a new issue on github.\n\nFollow this link:\nhttps://github.com/flapdoodle-oss/embedmongo.flapdoodle.de/issues\n\nThank you:)\n----------------------------------------------------\n\n";
            throw new IllegalStateException("Couldn't kill mongod process!" + message);
        }
        return state.returnCode;
    }

    public static ProcessControl fromCommandLine(List<String> commandLine, boolean redirectErrorStream) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        if (redirectErrorStream) {
            processBuilder.redirectErrorStream();
        }
        return new ProcessControl(processBuilder.start());
    }

    public static boolean executeCommandLine(String label, ProcessConfig processConfig) {
        boolean ret = false;
        List<String> commandLine = processConfig.getCommandLine();
        try {
            ProcessControl process = ProcessControl.fromCommandLine(processConfig.getCommandLine(), processConfig.getError() == null);
            Processors.connect(process.getReader(), processConfig.getOutput());
            Thread.sleep(10L);
            ret = process.stop() == 0;
            _logger.info("execSuccess: " + ret + " " + commandLine);
            return ret;
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "" + commandLine, e);
        }
        catch (InterruptedException e) {
            _logger.log(Level.SEVERE, "" + commandLine, e);
        }
        return false;
    }

    public static boolean killProcess(Platform platform, IStreamProcessor output, int pid) {
        if (platform == Platform.Linux || platform == Platform.OS_X) {
            return ProcessControl.executeCommandLine("[kill process]", new ProcessConfig(Collections.newArrayList("kill", "-2", "" + pid), output));
        }
        return false;
    }

    public static boolean tryKillProcess(Platform platform, IStreamProcessor output, int pid) {
        if (platform == Platform.Windows) {
            return ProcessControl.executeCommandLine("[taskkill process]", new ProcessConfig(Collections.newArrayList("taskkill", "/F", "/pid", "" + pid), output));
        }
        return false;
    }

    private Integer getProcessID() {
        Class<?> clazz = this._process.getClass();
        try {
            if (clazz.getName().equals("java.lang.UNIXProcess")) {
                Field pidField = clazz.getDeclaredField("pid");
                pidField.setAccessible(true);
                Object value = pidField.get(this._process);
                if (value instanceof Integer) {
                    return (Integer)value;
                }
            }
        }
        catch (SecurityException sx) {
            sx.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    static class ProcessState {
        protected int returnCode;
        boolean killed = false;

        ProcessState() {
        }
    }
}

