/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo;

import de.flapdoodle.embedmongo.Files;
import de.flapdoodle.embedmongo.MongodProcess;
import de.flapdoodle.embedmongo.config.MongodConfig;
import de.flapdoodle.embedmongo.config.MongodProcessOutputConfig;
import de.flapdoodle.embedmongo.distribution.Distribution;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class MongodExecutable {
    private static Logger logger = Logger.getLogger(MongodExecutable.class.getName());
    private final MongodConfig mongodConfig;
    private final MongodProcessOutputConfig mongodOutputConfig;
    private final File mongodExecutable;
    private boolean stopped;
    private final Distribution distribution;

    public MongodExecutable(Distribution distribution, MongodConfig mongodConfig, MongodProcessOutputConfig mongodOutputConfig, File mongodExecutable) {
        this.distribution = distribution;
        this.mongodConfig = mongodConfig;
        this.mongodOutputConfig = mongodOutputConfig;
        this.mongodExecutable = mongodExecutable;
        Runtime.getRuntime().addShutdownHook(new JobKiller());
    }

    public synchronized void cleanup() {
        if (!this.stopped) {
            if (this.mongodExecutable.exists() && !Files.forceDelete(this.mongodExecutable)) {
                logger.warning("Could not delete mongod executable NOW: " + this.mongodExecutable);
            }
            this.stopped = true;
        }
    }

    public File getFile() {
        return this.mongodExecutable;
    }

    public MongodProcess start() throws IOException {
        return new MongodProcess(this.distribution, this.mongodConfig, this.mongodOutputConfig, this);
    }

    class JobKiller
    extends Thread {
        JobKiller() {
        }

        @Override
        public void run() {
            MongodExecutable.this.cleanup();
        }
    }
}

