/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo;

import de.flapdoodle.embedmongo.Files;
import de.flapdoodle.embedmongo.MongodExecutable;
import de.flapdoodle.embedmongo.config.MongodConfig;
import de.flapdoodle.embedmongo.config.MongodProcessOutputConfig;
import de.flapdoodle.embedmongo.distribution.Distribution;
import de.flapdoodle.embedmongo.io.LogWatchStreamProcessor;
import de.flapdoodle.embedmongo.io.Processors;
import de.flapdoodle.embedmongo.io.StreamToLineProcessor;
import de.flapdoodle.embedmongo.runtime.Mongod;
import de.flapdoodle.embedmongo.runtime.Network;
import de.flapdoodle.embedmongo.runtime.ProcessControl;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MongodProcess {
    private static Logger logger = Logger.getLogger(MongodProcess.class.getName());
    public static final int TIMEOUT = 20000;
    private final MongodConfig config;
    private final MongodProcessOutputConfig outputConfig;
    private final MongodExecutable mongodExecutable;
    private ProcessControl process;
    private int mongodProcessId;
    private File dbDir;
    private boolean stopped = false;
    private Distribution distribution;

    public MongodProcess(Distribution distribution, MongodConfig config, MongodProcessOutputConfig outputConfig, MongodExecutable mongodExecutable) throws IOException {
        this.config = config;
        this.outputConfig = outputConfig;
        this.mongodExecutable = mongodExecutable;
        this.distribution = distribution;
        try {
            File tmpDbDir;
            if (config.getDatabaseDir() != null) {
                tmpDbDir = Files.createOrCheckDir(config.getDatabaseDir());
            } else {
                this.dbDir = tmpDbDir = Files.createTempDir("embedmongo-db");
            }
            this.process = ProcessControl.fromCommandLine(Mongod.enhanceCommandLinePlattformSpecific(distribution, Mongod.getCommandLine(this.config, this.mongodExecutable.getFile(), tmpDbDir)), true);
            Runtime.getRuntime().addShutdownHook(new JobKiller());
            LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor("waiting for connections on port", "failed", StreamToLineProcessor.wrap(outputConfig.getMongodOutput()));
            Processors.connect(this.process.getReader(), logWatch);
            Processors.connect(this.process.getError(), StreamToLineProcessor.wrap(outputConfig.getMongodError()));
            logWatch.waitForResult(20000L);
            if (!logWatch.isInitWithSuccess()) {
                throw new IOException("Could not start mongod process");
            }
            this.mongodProcessId = Mongod.getMongodProcessId(logWatch.getOutput(), -1);
        }
        catch (IOException iox) {
            this.stop();
            throw iox;
        }
    }

    public synchronized void stop() {
        if (!this.stopped) {
            this.stopped = true;
            logger.warning("try to stop mongod");
            if (!this.sendStopToMongoInstance()) {
                logger.warning("could not stop mongod with db command, try next");
                if (!this.sendKillToMongodProcess()) {
                    logger.warning("could not stop mongod, try next");
                    if (!this.tryKillToMongodProcess()) {
                        logger.warning("could not stop mongod the second time, try one last thing");
                    }
                }
            }
            this.process.stop();
            if (this.dbDir != null && !Files.forceDelete(this.dbDir)) {
                logger.warning("Could not delete temp db dir: " + this.dbDir);
            }
        }
    }

    private boolean sendStopToMongoInstance() {
        try {
            return Mongod.sendShutdown(Network.getLocalHost(), this.config.getPort());
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "sendStop", e);
            return false;
        }
    }

    private boolean sendKillToMongodProcess() {
        if (this.mongodProcessId > 0) {
            return ProcessControl.killProcess(this.distribution.getPlatform(), StreamToLineProcessor.wrap(this.outputConfig.getCommandsOutput()), this.mongodProcessId);
        }
        return false;
    }

    private boolean tryKillToMongodProcess() {
        if (this.mongodProcessId > 0) {
            return ProcessControl.tryKillProcess(this.distribution.getPlatform(), StreamToLineProcessor.wrap(this.outputConfig.getCommandsOutput()), this.mongodProcessId);
        }
        return false;
    }

    class JobKiller
    extends Thread {
        JobKiller() {
        }

        @Override
        public void run() {
            MongodProcess.this.stop();
        }
    }
}

