/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo.runtime;

import de.flapdoodle.embedmongo.collections.Collections;
import de.flapdoodle.embedmongo.config.ProcessConfig;
import de.flapdoodle.embedmongo.distribution.Platform;
import de.flapdoodle.embedmongo.io.IStreamProcessor;
import de.flapdoodle.embedmongo.io.Processors;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessControl {
    private static Logger logger = Logger.getLogger(ProcessControl.class.getName());
    public static final int SLEEPT_TIMEOUT = 10;
    private Process process;
    private InputStreamReader reader;
    private InputStreamReader error;
    private Integer pid;

    public ProcessControl(Process process) {
        this.process = process;
        this.reader = new InputStreamReader(this.process.getInputStream());
        this.error = new InputStreamReader(this.process.getErrorStream());
        this.pid = this.getProcessID();
    }

    public Reader getReader() {
        return this.reader;
    }

    public InputStreamReader getError() {
        return this.error;
    }

    public int stop() {
        this.closeIOAndDestroy();
        return this.waitForProcessGotKilled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeIOAndDestroy() {
        if (this.process != null) {
            try {
                this.process.getErrorStream().close();
                this.process.getInputStream().close();
                this.process.getOutputStream().close();
            }
            catch (IOException e) {
                logger.severe(e.getMessage());
            }
            finally {
                this.process.destroy();
            }
            this.reader = null;
        }
    }

    private int waitForProcessGotKilled() {
        final ProcessState state = new ProcessState();
        final Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    state.returnCode = ProcessControl.this.process.waitFor();
                }
                catch (InterruptedException e) {
                    logger.severe(e.getMessage());
                }
                finally {
                    state.setKilled(true);
                    timer.cancel();
                }
            }
        }, 0L, 10L);
        int countDown = 100;
        while (!state.isKilled() && countDown-- > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                logger.severe(e.getMessage());
            }
        }
        if (!state.isKilled()) {
            timer.cancel();
            String message = "\n\n----------------------------------------------------\nSomething bad happend. We couldn't kill mongod process, and tried a lot.\nIf you want this problem solved you can help us if you open a new issue on github.\n\nFollow this link:\nhttps://github.com/flapdoodle-oss/embedmongo.flapdoodle.de/issues\n\nThank you:)\n----------------------------------------------------\n\n";
            throw new IllegalStateException("Couldn't kill mongod process!" + message);
        }
        return state.returnCode;
    }

    public static ProcessControl fromCommandLine(List<String> commandLine, boolean redirectErrorStream) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        if (redirectErrorStream) {
            processBuilder.redirectErrorStream();
        }
        return new ProcessControl(processBuilder.start());
    }

    public static boolean executeCommandLine(String label, ProcessConfig processConfig) {
        boolean ret = false;
        List<String> commandLine = processConfig.getCommandLine();
        try {
            ProcessControl process = ProcessControl.fromCommandLine(processConfig.getCommandLine(), processConfig.getError() == null);
            Processors.connect(process.getReader(), processConfig.getOutput());
            Thread.sleep(10L);
            ret = process.stop() == 0;
            logger.info("execSuccess: " + ret + " " + commandLine);
            return ret;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "" + commandLine, e);
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "" + commandLine, e);
        }
        return false;
    }

    public static boolean killProcess(Platform platform, IStreamProcessor output, int pid) {
        if (platform == Platform.Linux || platform == Platform.OS_X) {
            return ProcessControl.executeCommandLine("[kill process]", new ProcessConfig(Collections.newArrayList("kill", "-2", "" + pid), output));
        }
        return false;
    }

    public static boolean tryKillProcess(Platform platform, IStreamProcessor output, int pid) {
        if (platform == Platform.Windows) {
            return ProcessControl.executeCommandLine("[taskkill process]", new ProcessConfig(Collections.newArrayList("taskkill", "/F", "/pid", "" + pid), output));
        }
        return false;
    }

    private Integer getProcessID() {
        Class<?> clazz = this.process.getClass();
        try {
            if (clazz.getName().equals("java.lang.UNIXProcess")) {
                Field pidField = clazz.getDeclaredField("pid");
                pidField.setAccessible(true);
                Object value = pidField.get(this.process);
                if (value instanceof Integer) {
                    return (Integer)value;
                }
            }
        }
        catch (SecurityException sx) {
            sx.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    static class ProcessState {
        protected int returnCode;
        private boolean killed = false;

        ProcessState() {
        }

        public boolean isKilled() {
            return this.killed;
        }

        public void setKilled(boolean killed) {
            this.killed = killed;
        }
    }
}

