package de.flapdoodle.eval.core;

import java.math.MathContext;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link EvaluationContext}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEvaluationContext.builder()}.
 */
@Generated(from = "EvaluationContext", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableEvaluationContext implements EvaluationContext {
  private final MathContext mathContext;
  private final ZoneId zoneId;

  private ImmutableEvaluationContext(MathContext mathContext, ZoneId zoneId) {
    this.mathContext = mathContext;
    this.zoneId = zoneId;
  }

  /**
   * @return The value of the {@code mathContext} attribute
   */
  @Override
  public MathContext mathContext() {
    return mathContext;
  }

  /**
   * @return The value of the {@code zoneId} attribute
   */
  @Override
  public ZoneId zoneId() {
    return zoneId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvaluationContext#mathContext() mathContext} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mathContext
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluationContext withMathContext(MathContext value) {
    if (this.mathContext == value) return this;
    MathContext newValue = Objects.requireNonNull(value, "mathContext");
    return new ImmutableEvaluationContext(newValue, this.zoneId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvaluationContext#zoneId() zoneId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zoneId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluationContext withZoneId(ZoneId value) {
    if (this.zoneId == value) return this;
    ZoneId newValue = Objects.requireNonNull(value, "zoneId");
    return new ImmutableEvaluationContext(this.mathContext, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEvaluationContext} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEvaluationContext
        && equalTo(0, (ImmutableEvaluationContext) another);
  }

  private boolean equalTo(int synthetic, ImmutableEvaluationContext another) {
    return mathContext.equals(another.mathContext)
        && zoneId.equals(another.zoneId);
  }

  /**
   * Computes a hash code from attributes: {@code mathContext}, {@code zoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + mathContext.hashCode();
    h += (h << 5) + zoneId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EvaluationContext} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EvaluationContext{"
        + "mathContext=" + mathContext
        + ", zoneId=" + zoneId
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link EvaluationContext} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EvaluationContext instance
   */
  public static ImmutableEvaluationContext copyOf(EvaluationContext instance) {
    if (instance instanceof ImmutableEvaluationContext) {
      return (ImmutableEvaluationContext) instance;
    }
    return ImmutableEvaluationContext.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEvaluationContext ImmutableEvaluationContext}.
   * <pre>
   * ImmutableEvaluationContext.builder()
   *    .mathContext(java.math.MathContext) // required {@link EvaluationContext#mathContext() mathContext}
   *    .zoneId(java.time.ZoneId) // required {@link EvaluationContext#zoneId() zoneId}
   *    .build();
   * </pre>
   * @return A new ImmutableEvaluationContext builder
   */
  public static ImmutableEvaluationContext.Builder builder() {
    return new ImmutableEvaluationContext.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEvaluationContext ImmutableEvaluationContext}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EvaluationContext", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MATH_CONTEXT = 0x1L;
    private static final long INIT_BIT_ZONE_ID = 0x2L;
    private long initBits = 0x3L;

    private MathContext mathContext;
    private ZoneId zoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EvaluationContext} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EvaluationContext instance) {
      Objects.requireNonNull(instance, "instance");
      mathContext(instance.mathContext());
      zoneId(instance.zoneId());
      return this;
    }

    /**
     * Initializes the value for the {@link EvaluationContext#mathContext() mathContext} attribute.
     * @param mathContext The value for mathContext 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mathContext(MathContext mathContext) {
      this.mathContext = Objects.requireNonNull(mathContext, "mathContext");
      initBits &= ~INIT_BIT_MATH_CONTEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link EvaluationContext#zoneId() zoneId} attribute.
     * @param zoneId The value for zoneId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder zoneId(ZoneId zoneId) {
      this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
      initBits &= ~INIT_BIT_ZONE_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEvaluationContext ImmutableEvaluationContext}.
     * @return An immutable instance of EvaluationContext
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEvaluationContext build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEvaluationContext(mathContext, zoneId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MATH_CONTEXT) != 0) attributes.add("mathContext");
      if ((initBits & INIT_BIT_ZONE_ID) != 0) attributes.add("zoneId");
      return "Cannot build EvaluationContext, some of required attributes are not set " + attributes;
    }
  }
}
