package de.flapdoodle.eval.core.evaluables;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OperatorMapping}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOperatorMapping.builder()}.
 */
@Generated(from = "OperatorMapping", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableOperatorMapping implements OperatorMapping {
  private final int precedence;
  private final boolean isLeftAssociative;
  private final String evaluatable;

  private ImmutableOperatorMapping(int precedence, boolean isLeftAssociative, String evaluatable) {
    this.precedence = precedence;
    this.isLeftAssociative = isLeftAssociative;
    this.evaluatable = evaluatable;
  }

  /**
   * @return The operator's precedence.
   */
  @Override
  public int precedence() {
    return precedence;
  }

  /**
   * If operators with same precedence are evaluated from left to right.
   * @return The associativity.
   */
  @Override
  public boolean isLeftAssociative() {
    return isLeftAssociative;
  }

  /**
   * name of evaluatable delegate
   */
  @Override
  public String evaluatable() {
    return evaluatable;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OperatorMapping#precedence() precedence} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for precedence
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOperatorMapping withPrecedence(int value) {
    if (this.precedence == value) return this;
    return new ImmutableOperatorMapping(value, this.isLeftAssociative, this.evaluatable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OperatorMapping#isLeftAssociative() isLeftAssociative} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isLeftAssociative
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOperatorMapping withIsLeftAssociative(boolean value) {
    if (this.isLeftAssociative == value) return this;
    return new ImmutableOperatorMapping(this.precedence, value, this.evaluatable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OperatorMapping#evaluatable() evaluatable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for evaluatable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOperatorMapping withEvaluatable(String value) {
    String newValue = Objects.requireNonNull(value, "evaluatable");
    if (this.evaluatable.equals(newValue)) return this;
    return new ImmutableOperatorMapping(this.precedence, this.isLeftAssociative, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOperatorMapping} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOperatorMapping
        && equalTo(0, (ImmutableOperatorMapping) another);
  }

  private boolean equalTo(int synthetic, ImmutableOperatorMapping another) {
    return precedence == another.precedence
        && isLeftAssociative == another.isLeftAssociative
        && evaluatable.equals(another.evaluatable);
  }

  /**
   * Computes a hash code from attributes: {@code precedence}, {@code isLeftAssociative}, {@code evaluatable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + precedence;
    h += (h << 5) + Boolean.hashCode(isLeftAssociative);
    h += (h << 5) + evaluatable.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OperatorMapping} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OperatorMapping{"
        + "precedence=" + precedence
        + ", isLeftAssociative=" + isLeftAssociative
        + ", evaluatable=" + evaluatable
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link OperatorMapping} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OperatorMapping instance
   */
  public static ImmutableOperatorMapping copyOf(OperatorMapping instance) {
    if (instance instanceof ImmutableOperatorMapping) {
      return (ImmutableOperatorMapping) instance;
    }
    return ImmutableOperatorMapping.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOperatorMapping ImmutableOperatorMapping}.
   * <pre>
   * ImmutableOperatorMapping.builder()
   *    .precedence(int) // required {@link OperatorMapping#precedence() precedence}
   *    .isLeftAssociative(boolean) // required {@link OperatorMapping#isLeftAssociative() isLeftAssociative}
   *    .evaluatable(String) // required {@link OperatorMapping#evaluatable() evaluatable}
   *    .build();
   * </pre>
   * @return A new ImmutableOperatorMapping builder
   */
  public static ImmutableOperatorMapping.Builder builder() {
    return new ImmutableOperatorMapping.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOperatorMapping ImmutableOperatorMapping}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OperatorMapping", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PRECEDENCE = 0x1L;
    private static final long INIT_BIT_IS_LEFT_ASSOCIATIVE = 0x2L;
    private static final long INIT_BIT_EVALUATABLE = 0x4L;
    private long initBits = 0x7L;

    private int precedence;
    private boolean isLeftAssociative;
    private String evaluatable;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OperatorMapping} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OperatorMapping instance) {
      Objects.requireNonNull(instance, "instance");
      precedence(instance.precedence());
      isLeftAssociative(instance.isLeftAssociative());
      evaluatable(instance.evaluatable());
      return this;
    }

    /**
     * Initializes the value for the {@link OperatorMapping#precedence() precedence} attribute.
     * @param precedence The value for precedence 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder precedence(int precedence) {
      this.precedence = precedence;
      initBits &= ~INIT_BIT_PRECEDENCE;
      return this;
    }

    /**
     * Initializes the value for the {@link OperatorMapping#isLeftAssociative() isLeftAssociative} attribute.
     * @param isLeftAssociative The value for isLeftAssociative 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isLeftAssociative(boolean isLeftAssociative) {
      this.isLeftAssociative = isLeftAssociative;
      initBits &= ~INIT_BIT_IS_LEFT_ASSOCIATIVE;
      return this;
    }

    /**
     * Initializes the value for the {@link OperatorMapping#evaluatable() evaluatable} attribute.
     * @param evaluatable The value for evaluatable 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder evaluatable(String evaluatable) {
      this.evaluatable = Objects.requireNonNull(evaluatable, "evaluatable");
      initBits &= ~INIT_BIT_EVALUATABLE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOperatorMapping ImmutableOperatorMapping}.
     * @return An immutable instance of OperatorMapping
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOperatorMapping build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOperatorMapping(precedence, isLeftAssociative, evaluatable);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PRECEDENCE) != 0) attributes.add("precedence");
      if ((initBits & INIT_BIT_IS_LEFT_ASSOCIATIVE) != 0) attributes.add("isLeftAssociative");
      if ((initBits & INIT_BIT_EVALUATABLE) != 0) attributes.add("evaluatable");
      return "Cannot build OperatorMapping, some of required attributes are not set " + attributes;
    }
  }
}
