package de.flapdoodle.eval.core.tree;

import de.flapdoodle.eval.core.exceptions.EvaluationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link EvalFailedWithException}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEvalFailedWithException.builder()}.
 */
@Generated(from = "EvalFailedWithException", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableEvalFailedWithException
    extends EvalFailedWithException {
  private final EvaluationException exception;

  private ImmutableEvalFailedWithException(EvaluationException exception) {
    this.exception = exception;
  }

  /**
   * @return The value of the {@code exception} attribute
   */
  @Override
  public EvaluationException exception() {
    return exception;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvalFailedWithException#exception() exception} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for exception
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvalFailedWithException withException(EvaluationException value) {
    if (this.exception == value) return this;
    EvaluationException newValue = Objects.requireNonNull(value, "exception");
    return new ImmutableEvalFailedWithException(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEvalFailedWithException} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEvalFailedWithException
        && equalTo(0, (ImmutableEvalFailedWithException) another);
  }

  private boolean equalTo(int synthetic, ImmutableEvalFailedWithException another) {
    return exception.equals(another.exception);
  }

  /**
   * Computes a hash code from attributes: {@code exception}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + exception.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EvalFailedWithException} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EvalFailedWithException{"
        + "exception=" + exception
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link EvalFailedWithException} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EvalFailedWithException instance
   */
  public static ImmutableEvalFailedWithException copyOf(EvalFailedWithException instance) {
    if (instance instanceof ImmutableEvalFailedWithException) {
      return (ImmutableEvalFailedWithException) instance;
    }
    return ImmutableEvalFailedWithException.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEvalFailedWithException ImmutableEvalFailedWithException}.
   * <pre>
   * ImmutableEvalFailedWithException.builder()
   *    .exception(de.flapdoodle.eval.core.exceptions.EvaluationException) // required {@link EvalFailedWithException#exception() exception}
   *    .build();
   * </pre>
   * @return A new ImmutableEvalFailedWithException builder
   */
  public static ImmutableEvalFailedWithException.Builder builder() {
    return new ImmutableEvalFailedWithException.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEvalFailedWithException ImmutableEvalFailedWithException}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EvalFailedWithException", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_EXCEPTION = 0x1L;
    private long initBits = 0x1L;

    private EvaluationException exception;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EvalFailedWithException} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EvalFailedWithException instance) {
      Objects.requireNonNull(instance, "instance");
      exception(instance.exception());
      return this;
    }

    /**
     * Initializes the value for the {@link EvalFailedWithException#exception() exception} attribute.
     * @param exception The value for exception 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder exception(EvaluationException exception) {
      this.exception = Objects.requireNonNull(exception, "exception");
      initBits &= ~INIT_BIT_EXCEPTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEvalFailedWithException ImmutableEvalFailedWithException}.
     * @return An immutable instance of EvalFailedWithException
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEvalFailedWithException build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEvalFailedWithException(exception);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EXCEPTION) != 0) attributes.add("exception");
      return "Cannot build EvalFailedWithException, some of required attributes are not set " + attributes;
    }
  }
}
