package de.flapdoodle.eval.core.tree;

import de.flapdoodle.types.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link VariableNames}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVariableNames.builder()}.
 */
@Generated(from = "VariableNames", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableVariableNames extends VariableNames {
  private final List<Pair<Integer, String>> map;
  private transient final Map<String, Integer> nameHashMap;
  private transient final Set<String> names;

  private ImmutableVariableNames(List<Pair<Integer, String>> map) {
    this.map = map;
    this.nameHashMap = initShim.nameHashMap();
    this.names = initShim.names();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "VariableNames", generator = "Immutables")
  private final class InitShim {
    private byte nameHashMapBuildStage = STAGE_UNINITIALIZED;
    private Map<String, Integer> nameHashMap;

    Map<String, Integer> nameHashMap() {
      if (nameHashMapBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nameHashMapBuildStage == STAGE_UNINITIALIZED) {
        nameHashMapBuildStage = STAGE_INITIALIZING;
        this.nameHashMap = Objects.requireNonNull(ImmutableVariableNames.super.nameHashMap(), "nameHashMap");
        nameHashMapBuildStage = STAGE_INITIALIZED;
      }
      return this.nameHashMap;
    }

    private byte namesBuildStage = STAGE_UNINITIALIZED;
    private Set<String> names;

    Set<String> names() {
      if (namesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (namesBuildStage == STAGE_UNINITIALIZED) {
        namesBuildStage = STAGE_INITIALIZING;
        this.names = Objects.requireNonNull(ImmutableVariableNames.super.names(), "names");
        namesBuildStage = STAGE_INITIALIZED;
      }
      return this.names;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (nameHashMapBuildStage == STAGE_INITIALIZING) attributes.add("nameHashMap");
      if (namesBuildStage == STAGE_INITIALIZING) attributes.add("names");
      return "Cannot build VariableNames, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code map} attribute
   */
  @Override
  protected List<Pair<Integer, String>> map() {
    return map;
  }

  /**
   * @return The computed-at-construction value of the {@code nameHashMap} attribute
   */
  @Override
  public Map<String, Integer> nameHashMap() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.nameHashMap()
        : this.nameHashMap;
  }

  /**
   * @return The computed-at-construction value of the {@code names} attribute
   */
  @Override
  public Set<String> names() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.names()
        : this.names;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VariableNames#map() map}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableVariableNames withMap(Pair<Integer, String>... elements) {
    List<Pair<Integer, String>> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableVariableNames(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VariableNames#map() map}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of map elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableVariableNames withMap(Iterable<? extends Pair<Integer, String>> elements) {
    if (this.map == elements) return this;
    List<Pair<Integer, String>> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableVariableNames(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVariableNames} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVariableNames
        && equalTo(0, (ImmutableVariableNames) another);
  }

  private boolean equalTo(int synthetic, ImmutableVariableNames another) {
    return map.equals(another.map)
        && nameHashMap.equals(another.nameHashMap)
        && names.equals(another.names);
  }

  /**
   * Computes a hash code from attributes: {@code map}, {@code nameHashMap}, {@code names}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + map.hashCode();
    h += (h << 5) + nameHashMap.hashCode();
    h += (h << 5) + names.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code VariableNames} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VariableNames{"
        + "map=" + map
        + ", nameHashMap=" + nameHashMap
        + ", names=" + names
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link VariableNames} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VariableNames instance
   */
  public static ImmutableVariableNames copyOf(VariableNames instance) {
    if (instance instanceof ImmutableVariableNames) {
      return (ImmutableVariableNames) instance;
    }
    return ImmutableVariableNames.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVariableNames ImmutableVariableNames}.
   * <pre>
   * ImmutableVariableNames.builder()
   *    .addMap|addAllMap(de.flapdoodle.types.Pair&amp;lt;Integer, String&amp;gt;) // {@link VariableNames#map() map} elements
   *    .build();
   * </pre>
   * @return A new ImmutableVariableNames builder
   */
  public static ImmutableVariableNames.Builder builder() {
    return new ImmutableVariableNames.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableVariableNames ImmutableVariableNames}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "VariableNames", generator = "Immutables")
  public static final class Builder {
    private List<Pair<Integer, String>> map = new ArrayList<Pair<Integer, String>>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code VariableNames} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(VariableNames instance) {
      Objects.requireNonNull(instance, "instance");
      addAllMap(instance.map());
      return this;
    }

    /**
     * Adds one element to {@link VariableNames#map() map} list.
     * @param element A map element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMap(Pair<Integer, String> element) {
      this.map.add(Objects.requireNonNull(element, "map element"));
      return this;
    }

    /**
     * Adds elements to {@link VariableNames#map() map} list.
     * @param elements An array of map elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addMap(Pair<Integer, String>... elements) {
      for (Pair<Integer, String> element : elements) {
        this.map.add(Objects.requireNonNull(element, "map element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link VariableNames#map() map} list.
     * @param elements An iterable of map elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder map(Iterable<? extends Pair<Integer, String>> elements) {
      this.map.clear();
      return addAllMap(elements);
    }

    /**
     * Adds elements to {@link VariableNames#map() map} list.
     * @param elements An iterable of map elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMap(Iterable<? extends Pair<Integer, String>> elements) {
      for (Pair<Integer, String> element : elements) {
        this.map.add(Objects.requireNonNull(element, "map element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableVariableNames ImmutableVariableNames}.
     * @return An immutable instance of VariableNames
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVariableNames build() {
      return new ImmutableVariableNames(createUnmodifiableList(true, map));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
