package de.flapdoodle.eval.example;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Value.ArrayValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableArrayValue.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableArrayValue.of()}.
 */
@Generated(from = "Value.ArrayValue", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableArrayValue extends Value.ArrayValue {
  private final Values wrapped;

  private ImmutableArrayValue(Values wrapped) {
    this.wrapped = Objects.requireNonNull(wrapped, "wrapped");
  }

  private ImmutableArrayValue(ImmutableArrayValue original, Values wrapped) {
    this.wrapped = wrapped;
  }

  /**
   * @return The value of the {@code wrapped} attribute
   */
  @Override
  public Values wrapped() {
    return wrapped;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Value.ArrayValue#wrapped() wrapped} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for wrapped
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArrayValue withWrapped(Values value) {
    if (this.wrapped == value) return this;
    Values newValue = Objects.requireNonNull(value, "wrapped");
    return new ImmutableArrayValue(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableArrayValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableArrayValue
        && equalTo(0, (ImmutableArrayValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableArrayValue another) {
    return wrapped.equals(another.wrapped);
  }

  /**
   * Computes a hash code from attributes: {@code wrapped}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + wrapped.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code ArrayValue} instance.
   * @param wrapped The value for the {@code wrapped} attribute
   * @return An immutable ArrayValue instance
   */
  public static ImmutableArrayValue of(Values wrapped) {
    return new ImmutableArrayValue(wrapped);
  }

  /**
   * Creates an immutable copy of a {@link Value.ArrayValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ArrayValue instance
   */
  public static ImmutableArrayValue copyOf(Value.ArrayValue instance) {
    if (instance instanceof ImmutableArrayValue) {
      return (ImmutableArrayValue) instance;
    }
    return ImmutableArrayValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableArrayValue ImmutableArrayValue}.
   * <pre>
   * ImmutableArrayValue.builder()
   *    .wrapped(de.flapdoodle.eval.example.Values) // required {@link Value.ArrayValue#wrapped() wrapped}
   *    .build();
   * </pre>
   * @return A new ImmutableArrayValue builder
   */
  public static ImmutableArrayValue.Builder builder() {
    return new ImmutableArrayValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableArrayValue ImmutableArrayValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Value.ArrayValue", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_WRAPPED = 0x1L;
    private long initBits = 0x1L;

    private Values wrapped;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ArrayValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Value.ArrayValue instance) {
      Objects.requireNonNull(instance, "instance");
      wrapped(instance.wrapped());
      return this;
    }

    /**
     * Initializes the value for the {@link Value.ArrayValue#wrapped() wrapped} attribute.
     * @param wrapped The value for wrapped 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder wrapped(Values wrapped) {
      this.wrapped = Objects.requireNonNull(wrapped, "wrapped");
      initBits &= ~INIT_BIT_WRAPPED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableArrayValue ImmutableArrayValue}.
     * @return An immutable instance of ArrayValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableArrayValue build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableArrayValue(null, wrapped);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WRAPPED) != 0) attributes.add("wrapped");
      return "Cannot build ArrayValue, some of required attributes are not set " + attributes;
    }
  }
}
