package de.flapdoodle.eval.example;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Value.MapValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMapValue.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableMapValue.of()}.
 */
@Generated(from = "Value.MapValue", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableMapValue extends Value.MapValue {
  private final ValueMap wrapped;

  private ImmutableMapValue(ValueMap wrapped) {
    this.wrapped = Objects.requireNonNull(wrapped, "wrapped");
  }

  private ImmutableMapValue(ImmutableMapValue original, ValueMap wrapped) {
    this.wrapped = wrapped;
  }

  /**
   * @return The value of the {@code wrapped} attribute
   */
  @Override
  public ValueMap wrapped() {
    return wrapped;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Value.MapValue#wrapped() wrapped} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for wrapped
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMapValue withWrapped(ValueMap value) {
    if (this.wrapped == value) return this;
    ValueMap newValue = Objects.requireNonNull(value, "wrapped");
    return new ImmutableMapValue(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMapValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMapValue
        && equalTo(0, (ImmutableMapValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableMapValue another) {
    return wrapped.equals(another.wrapped);
  }

  /**
   * Computes a hash code from attributes: {@code wrapped}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + wrapped.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code MapValue} instance.
   * @param wrapped The value for the {@code wrapped} attribute
   * @return An immutable MapValue instance
   */
  public static ImmutableMapValue of(ValueMap wrapped) {
    return new ImmutableMapValue(wrapped);
  }

  /**
   * Creates an immutable copy of a {@link Value.MapValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MapValue instance
   */
  public static ImmutableMapValue copyOf(Value.MapValue instance) {
    if (instance instanceof ImmutableMapValue) {
      return (ImmutableMapValue) instance;
    }
    return ImmutableMapValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMapValue ImmutableMapValue}.
   * <pre>
   * ImmutableMapValue.builder()
   *    .wrapped(de.flapdoodle.eval.example.ValueMap) // required {@link Value.MapValue#wrapped() wrapped}
   *    .build();
   * </pre>
   * @return A new ImmutableMapValue builder
   */
  public static ImmutableMapValue.Builder builder() {
    return new ImmutableMapValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMapValue ImmutableMapValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Value.MapValue", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_WRAPPED = 0x1L;
    private long initBits = 0x1L;

    private ValueMap wrapped;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MapValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Value.MapValue instance) {
      Objects.requireNonNull(instance, "instance");
      wrapped(instance.wrapped());
      return this;
    }

    /**
     * Initializes the value for the {@link Value.MapValue#wrapped() wrapped} attribute.
     * @param wrapped The value for wrapped 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder wrapped(ValueMap wrapped) {
      this.wrapped = Objects.requireNonNull(wrapped, "wrapped");
      initBits &= ~INIT_BIT_WRAPPED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMapValue ImmutableMapValue}.
     * @return An immutable instance of MapValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMapValue build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMapValue(null, wrapped);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WRAPPED) != 0) attributes.add("wrapped");
      return "Cannot build MapValue, some of required attributes are not set " + attributes;
    }
  }
}
