/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.evaluables;

import de.flapdoodle.eval.core.evaluables.Parameter;
import de.flapdoodle.eval.core.validation.ParameterValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="Parameter", generator="Immutables")
public final class ImmutableParameter<T>
implements Parameter<T> {
    private final Class<T> type;
    private final boolean isLazy;
    private final List<ParameterValidator<T>> validators;

    private ImmutableParameter(Class<T> type) {
        this.type = Objects.requireNonNull(type, "type");
        this.validators = Collections.emptyList();
        this.isLazy = Parameter.super.isLazy();
    }

    private ImmutableParameter(Builder<T> builder) {
        this.type = ((Builder)builder).type;
        this.validators = ImmutableParameter.createUnmodifiableList(true, ((Builder)builder).validators);
        this.isLazy = ((Builder)builder).isLazyIsSet() ? ((Builder)builder).isLazy : Parameter.super.isLazy();
    }

    private ImmutableParameter(Class<T> type, boolean isLazy, List<ParameterValidator<T>> validators) {
        this.type = type;
        this.isLazy = isLazy;
        this.validators = validators;
    }

    @Override
    public Class<T> type() {
        return this.type;
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public List<ParameterValidator<T>> validators() {
        return this.validators;
    }

    public final ImmutableParameter<T> withType(Class<T> value) {
        if (this.type == value) {
            return this;
        }
        Class<T> newValue = Objects.requireNonNull(value, "type");
        return new ImmutableParameter<T>(newValue, this.isLazy, this.validators);
    }

    public final ImmutableParameter<T> withIsLazy(boolean value) {
        if (this.isLazy == value) {
            return this;
        }
        return new ImmutableParameter<T>(this.type, value, this.validators);
    }

    @SafeVarargs
    public final ImmutableParameter<T> withValidators(ParameterValidator<T> ... elements) {
        List<ParameterValidator<T>> newValue = ImmutableParameter.createUnmodifiableList(false, ImmutableParameter.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableParameter<T>(this.type, this.isLazy, newValue);
    }

    public final ImmutableParameter<T> withValidators(Iterable<? extends ParameterValidator<T>> elements) {
        if (this.validators == elements) {
            return this;
        }
        List<ParameterValidator<T>> newValue = ImmutableParameter.createUnmodifiableList(false, ImmutableParameter.createSafeList(elements, true, false));
        return new ImmutableParameter<T>(this.type, this.isLazy, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableParameter && this.equalTo(0, (ImmutableParameter)another);
    }

    private boolean equalTo(int synthetic, ImmutableParameter<?> another) {
        return this.type.equals(another.type) && this.isLazy == another.isLazy && this.validators.equals(another.validators);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isLazy);
        h += (h << 5) + this.validators.hashCode();
        return h;
    }

    public String toString() {
        return "Parameter{type=" + this.type + ", isLazy=" + this.isLazy + ", validators=" + this.validators + "}";
    }

    public static <T> ImmutableParameter<T> of(Class<T> type) {
        return new ImmutableParameter<T>(type);
    }

    public static <T> ImmutableParameter<T> copyOf(Parameter<T> instance) {
        if (instance instanceof ImmutableParameter) {
            return (ImmutableParameter)instance;
        }
        return ImmutableParameter.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Parameter", generator="Immutables")
    public static final class Builder<T> {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long OPT_BIT_IS_LAZY = 1L;
        private long initBits = 1L;
        private long optBits;
        private Class<T> type;
        private boolean isLazy;
        private List<ParameterValidator<T>> validators = new ArrayList<ParameterValidator<T>>();

        private Builder() {
        }

        public final Builder<T> from(Parameter<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.isLazy(instance.isLazy());
            this.addAllValidators(instance.validators());
            return this;
        }

        public final Builder<T> type(Class<T> type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<T> isLazy(boolean isLazy) {
            this.isLazy = isLazy;
            this.optBits |= 1L;
            return this;
        }

        public final Builder<T> addValidators(ParameterValidator<T> element) {
            this.validators.add(Objects.requireNonNull(element, "validators element"));
            return this;
        }

        @SafeVarargs
        public final Builder<T> addValidators(ParameterValidator<T> ... elements) {
            for (ParameterValidator<T> element : elements) {
                this.validators.add(Objects.requireNonNull(element, "validators element"));
            }
            return this;
        }

        public final Builder<T> validators(Iterable<? extends ParameterValidator<T>> elements) {
            this.validators.clear();
            return this.addAllValidators(elements);
        }

        public final Builder<T> addAllValidators(Iterable<? extends ParameterValidator<T>> elements) {
            for (ParameterValidator<T> element : elements) {
                this.validators.add(Objects.requireNonNull(element, "validators element"));
            }
            return this;
        }

        public ImmutableParameter<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableParameter(this);
        }

        private boolean isLazyIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build Parameter, some of required attributes are not set " + attributes;
        }
    }
}

