/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.evaluables;

import de.flapdoodle.eval.core.evaluables.TypedEvaluable;
import de.flapdoodle.eval.core.evaluables.TypedEvaluables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="TypedEvaluables", generator="Immutables")
public final class ImmutableTypedEvaluables
extends TypedEvaluables {
    private final List<TypedEvaluable<?>> list;

    private ImmutableTypedEvaluables(List<TypedEvaluable<?>> list) {
        this.list = list;
    }

    @Override
    protected List<TypedEvaluable<?>> list() {
        return this.list;
    }

    @SafeVarargs
    public final ImmutableTypedEvaluables withList(TypedEvaluable<?> ... elements) {
        List<TypedEvaluable<?>> newValue = ImmutableTypedEvaluables.createUnmodifiableList(false, ImmutableTypedEvaluables.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTypedEvaluables(newValue);
    }

    public final ImmutableTypedEvaluables withList(Iterable<? extends TypedEvaluable<?>> elements) {
        if (this.list == elements) {
            return this;
        }
        List<TypedEvaluable<?>> newValue = ImmutableTypedEvaluables.createUnmodifiableList(false, ImmutableTypedEvaluables.createSafeList(elements, true, false));
        return new ImmutableTypedEvaluables(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTypedEvaluables && this.equalTo(0, (ImmutableTypedEvaluables)another);
    }

    private boolean equalTo(int synthetic, ImmutableTypedEvaluables another) {
        return this.list.equals(another.list);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.list.hashCode();
        return h;
    }

    public String toString() {
        return "TypedEvaluables{list=" + this.list + "}";
    }

    public static ImmutableTypedEvaluables copyOf(TypedEvaluables instance) {
        if (instance instanceof ImmutableTypedEvaluables) {
            return (ImmutableTypedEvaluables)instance;
        }
        return ImmutableTypedEvaluables.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="TypedEvaluables", generator="Immutables")
    public static final class Builder {
        private List<TypedEvaluable<?>> list = new ArrayList();

        private Builder() {
        }

        public final Builder from(TypedEvaluables instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllList(instance.list());
            return this;
        }

        public final Builder addList(TypedEvaluable<?> element) {
            this.list.add(Objects.requireNonNull(element, "list element"));
            return this;
        }

        @SafeVarargs
        public final Builder addList(TypedEvaluable<?> ... elements) {
            for (TypedEvaluable<?> element : elements) {
                this.list.add(Objects.requireNonNull(element, "list element"));
            }
            return this;
        }

        public final Builder list(Iterable<? extends TypedEvaluable<?>> elements) {
            this.list.clear();
            return this.addAllList(elements);
        }

        public final Builder addAllList(Iterable<? extends TypedEvaluable<?>> elements) {
            for (TypedEvaluable<?> element : elements) {
                this.list.add(Objects.requireNonNull(element, "list element"));
            }
            return this;
        }

        public ImmutableTypedEvaluables build() {
            return new ImmutableTypedEvaluables(ImmutableTypedEvaluables.createUnmodifiableList(true, this.list));
        }
    }
}

