/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.evaluables;

import de.flapdoodle.eval.core.evaluables.ImmutableParameter;
import de.flapdoodle.eval.core.exceptions.EvaluableException;
import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.core.validation.ParameterValidator;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public interface Parameter<T> {
    @Value.Parameter
    public Class<T> type();

    @Value.Default
    default public boolean isLazy() {
        return false;
    }

    public List<ParameterValidator<T>> validators();

    public static <T> ImmutableParameter<T> of(Class<T> type) {
        return ImmutableParameter.of(type);
    }

    public static <T> ImmutableParameter<T> lazyWith(Class<T> type) {
        return ImmutableParameter.of(type).withIsLazy(true);
    }

    @Deprecated
    @Value.Auxiliary
    default public void validate(Token token, Object parameterValue) throws EvaluationException {
        Optional<EvaluableException> error = this.validationError(parameterValue);
        if (error.isPresent()) {
            throw new EvaluationException(token, error.get());
        }
    }

    @Value.Auxiliary
    default public Optional<EvaluableException> validationError(Object parameterValue) {
        if (this.type().isInstance(parameterValue)) {
            T value = this.type().cast(parameterValue);
            for (ParameterValidator<T> validator : this.validators()) {
                Optional<EvaluableException> error = validator.validate(value);
                if (!error.isPresent()) continue;
                return error;
            }
        } else {
            return Optional.of(EvaluableException.ofUnsupportedDataTypeInOperation());
        }
        return Optional.empty();
    }
}

