/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.evaluables;

import de.flapdoodle.eval.core.EvaluationContext;
import de.flapdoodle.eval.core.VariableResolver;
import de.flapdoodle.eval.core.evaluables.Evaluable;
import de.flapdoodle.eval.core.evaluables.Parameter;
import de.flapdoodle.eval.core.evaluables.Signature;
import de.flapdoodle.eval.core.evaluables.TypedEvaluableAdapter;
import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.core.parser.Token;
import java.util.List;
import java.util.stream.Collectors;

public interface TypedEvaluable<T>
extends Evaluable<T> {
    public Signature<T> signature();

    public static <T> TypedEvaluable<T> of(Class<T> returnType, Arg0<T> function) {
        Evaluable<Object> evaluable = (valueResolver, evaluationContext, token, arguments) -> function.evaluate(valueResolver, evaluationContext, token);
        return new TypedEvaluableAdapter<Object>(Signature.of(returnType, new Parameter[0]), evaluable.named(function.toString()));
    }

    public static <T, A> TypedEvaluable<T> of(Class<T> returnType, Parameter<A> a, Arg1<A, T> function) {
        Evaluable<Object> evaluable = (valueResolver, evaluationContext, token, arguments) -> function.evaluate(valueResolver, evaluationContext, token, a.type().cast(arguments.get(0)));
        return new TypedEvaluableAdapter<Object>(Signature.of(returnType, a), evaluable.named(function.toString()));
    }

    public static <T, A> TypedEvaluable<T> of(Class<T> returnType, Class<A> a, Arg1<A, T> function) {
        return TypedEvaluable.of(returnType, Parameter.of(a), function);
    }

    public static <T, A> TypedEvaluable<T> ofVarArg(Class<T> returnType, Class<A> a, VarArg1<A, T> function) {
        Evaluable<Object> evaluable = (valueResolver, evaluationContext, token, arguments) -> function.evaluate(valueResolver, evaluationContext, token, arguments.stream().map(a::cast).collect(Collectors.toList()));
        return new TypedEvaluableAdapter<Object>(Signature.ofVarArg(returnType, Parameter.of(a)), evaluable.named(function.toString()));
    }

    public static <T, A, B> TypedEvaluable<T> of(Class<T> returnType, Parameter<A> a, Parameter<B> b, Arg2<A, B, T> function) {
        Evaluable<Object> evaluable = (valueResolver, evaluationContext, token, arguments) -> function.evaluate(valueResolver, evaluationContext, token, a.type().cast(arguments.get(0)), b.type().cast(arguments.get(1)));
        return new TypedEvaluableAdapter<Object>(Signature.of(returnType, a, b), evaluable.named(function.toString()));
    }

    public static <T, A, B> TypedEvaluable<T> of(Class<T> returnType, Class<A> a, Class<B> b, Arg2<A, B, T> function) {
        return TypedEvaluable.of(returnType, Parameter.of(a), Parameter.of(b), function);
    }

    public static <T, A, B, C> TypedEvaluable<T> of(Class<T> returnType, Class<A> a, Class<B> b, Class<C> c, Arg3<A, B, C, T> function) {
        return TypedEvaluable.of(returnType, Parameter.of(a), Parameter.of(b), Parameter.of(c), function);
    }

    public static <T, A, B, C> TypedEvaluable<T> of(Class<T> returnType, Parameter<A> a, Parameter<B> b, Parameter<C> c, Arg3<A, B, C, T> function) {
        Evaluable<Object> evaluable = (valueResolver, evaluationContext, token, arguments) -> function.evaluate(valueResolver, evaluationContext, token, a.type().cast(arguments.get(0)), b.type().cast(arguments.get(1)), c.type().cast(arguments.get(2)));
        return new TypedEvaluableAdapter<Object>(Signature.of(returnType, a, b, c), evaluable.named(function.toString()));
    }

    public static <T, A, B, C, D> TypedEvaluable<T> of(Class<T> returnType, Parameter<A> a, Parameter<B> b, Parameter<C> c, Parameter<D> d, Arg4<A, B, C, D, T> function) {
        Evaluable<Object> evaluable = (valueResolver, evaluationContext, token, arguments) -> function.evaluate(valueResolver, evaluationContext, token, a.type().cast(arguments.get(0)), b.type().cast(arguments.get(1)), c.type().cast(arguments.get(2)), d.type().cast(arguments.get(3)));
        return new TypedEvaluableAdapter<Object>(Signature.of(returnType, a, b, c, d), evaluable.named(function.toString()));
    }

    public static <T, A, B, C, D, E> TypedEvaluable<T> of(Class<T> returnType, Parameter<A> a, Parameter<B> b, Parameter<C> c, Parameter<D> d, Parameter<E> e, Arg5<A, B, C, D, E, T> function) {
        Evaluable<Object> evaluable = (valueResolver, evaluationContext, token, arguments) -> function.evaluate(valueResolver, evaluationContext, token, a.type().cast(arguments.get(0)), b.type().cast(arguments.get(1)), c.type().cast(arguments.get(2)), d.type().cast(arguments.get(3)), e.type().cast(arguments.get(4)));
        return new TypedEvaluableAdapter<Object>(Signature.of(returnType, a, b, c, d, e), evaluable.named(function.toString()));
    }

    public static <T, A, B, C, D, E, F> TypedEvaluable<T> of(Class<T> returnType, Parameter<A> a, Parameter<B> b, Parameter<C> c, Parameter<D> d, Parameter<E> e, Parameter<F> f, Arg6<A, B, C, D, E, F, T> function) {
        Evaluable<Object> evaluable = (valueResolver, evaluationContext, token, arguments) -> function.evaluate(valueResolver, evaluationContext, token, a.type().cast(arguments.get(0)), b.type().cast(arguments.get(1)), c.type().cast(arguments.get(2)), d.type().cast(arguments.get(3)), e.type().cast(arguments.get(4)), f.type().cast(arguments.get(5)));
        return new TypedEvaluableAdapter<Object>(Signature.of(returnType, a, b, c, d, e, f), evaluable.named(function.toString()));
    }

    public static <T, A, B, C, D, E, F, G> TypedEvaluable<T> of(Class<T> returnType, Parameter<A> a, Parameter<B> b, Parameter<C> c, Parameter<D> d, Parameter<E> e, Parameter<F> f, Parameter<G> g, Arg7<A, B, C, D, E, F, G, T> function) {
        Evaluable<Object> evaluable = (valueResolver, evaluationContext, token, arguments) -> function.evaluate(valueResolver, evaluationContext, token, a.type().cast(arguments.get(0)), b.type().cast(arguments.get(1)), c.type().cast(arguments.get(2)), d.type().cast(arguments.get(3)), e.type().cast(arguments.get(4)), f.type().cast(arguments.get(5)), g.type().cast(arguments.get(6)));
        return new TypedEvaluableAdapter<Object>(Signature.of(returnType, a, b, c, d, e, f, g), evaluable.named(function.toString()));
    }

    public static interface Arg7<A, B, C, D, E, F, G, T> {
        public T evaluate(VariableResolver var1, EvaluationContext var2, Token var3, A var4, B var5, C var6, D var7, E var8, F var9, G var10) throws EvaluationException;
    }

    public static interface Arg6<A, B, C, D, E, F, T> {
        public T evaluate(VariableResolver var1, EvaluationContext var2, Token var3, A var4, B var5, C var6, D var7, E var8, F var9) throws EvaluationException;
    }

    public static interface Arg5<A, B, C, D, E, T> {
        public T evaluate(VariableResolver var1, EvaluationContext var2, Token var3, A var4, B var5, C var6, D var7, E var8) throws EvaluationException;
    }

    public static interface Arg4<A, B, C, D, T> {
        public T evaluate(VariableResolver var1, EvaluationContext var2, Token var3, A var4, B var5, C var6, D var7) throws EvaluationException;
    }

    public static interface Arg3<A, B, C, T> {
        public T evaluate(VariableResolver var1, EvaluationContext var2, Token var3, A var4, B var5, C var6) throws EvaluationException;
    }

    public static interface Arg2<A, B, T> {
        public T evaluate(VariableResolver var1, EvaluationContext var2, Token var3, A var4, B var5) throws EvaluationException;
    }

    public static interface VarArg1<S, T> {
        public T evaluate(VariableResolver var1, EvaluationContext var2, Token var3, List<S> var4) throws EvaluationException;
    }

    public static interface Arg1<S, T> {
        public T evaluate(VariableResolver var1, EvaluationContext var2, Token var3, S var4) throws EvaluationException;
    }

    public static interface Arg0<T> {
        public T evaluate(VariableResolver var1, EvaluationContext var2, Token var3) throws EvaluationException;
    }
}

