/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.tree;

import de.flapdoodle.eval.core.tree.VariableNames;
import de.flapdoodle.types.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@Generated(from="VariableNames", generator="Immutables")
public final class ImmutableVariableNames
extends VariableNames {
    private final List<Pair<Integer, String>> map;
    private final transient Map<String, Integer> nameHashMap;
    private final transient Set<String> names;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableVariableNames(List<Pair<Integer, String>> map) {
        this.map = map;
        this.nameHashMap = this.initShim.nameHashMap();
        this.names = this.initShim.names();
        this.initShim = null;
    }

    @Override
    protected List<Pair<Integer, String>> map() {
        return this.map;
    }

    @Override
    public Map<String, Integer> nameHashMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nameHashMap() : this.nameHashMap;
    }

    @Override
    public Set<String> names() {
        InitShim shim = this.initShim;
        return shim != null ? shim.names() : this.names;
    }

    @SafeVarargs
    public final ImmutableVariableNames withMap(Pair<Integer, String> ... elements) {
        List<Pair<Integer, String>> newValue = ImmutableVariableNames.createUnmodifiableList(false, ImmutableVariableNames.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableVariableNames(newValue);
    }

    public final ImmutableVariableNames withMap(Iterable<? extends Pair<Integer, String>> elements) {
        if (this.map == elements) {
            return this;
        }
        List<? extends Pair<Integer, String>> newValue = ImmutableVariableNames.createUnmodifiableList(false, ImmutableVariableNames.createSafeList(elements, true, false));
        return new ImmutableVariableNames(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVariableNames && this.equalTo(0, (ImmutableVariableNames)another);
    }

    private boolean equalTo(int synthetic, ImmutableVariableNames another) {
        return this.map.equals(another.map) && this.nameHashMap.equals(another.nameHashMap) && this.names.equals(another.names);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.map.hashCode();
        h += (h << 5) + this.nameHashMap.hashCode();
        h += (h << 5) + this.names.hashCode();
        return h;
    }

    public String toString() {
        return "VariableNames{map=" + this.map + ", nameHashMap=" + this.nameHashMap + ", names=" + this.names + "}";
    }

    public static ImmutableVariableNames copyOf(VariableNames instance) {
        if (instance instanceof ImmutableVariableNames) {
            return (ImmutableVariableNames)instance;
        }
        return ImmutableVariableNames.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="VariableNames", generator="Immutables")
    public static final class Builder {
        private List<Pair<Integer, String>> map = new ArrayList<Pair<Integer, String>>();

        private Builder() {
        }

        public final Builder from(VariableNames instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllMap(instance.map());
            return this;
        }

        public final Builder addMap(Pair<Integer, String> element) {
            this.map.add(Objects.requireNonNull(element, "map element"));
            return this;
        }

        @SafeVarargs
        public final Builder addMap(Pair<Integer, String> ... elements) {
            for (Pair<Integer, String> element : elements) {
                this.map.add(Objects.requireNonNull(element, "map element"));
            }
            return this;
        }

        public final Builder map(Iterable<? extends Pair<Integer, String>> elements) {
            this.map.clear();
            return this.addAllMap(elements);
        }

        public final Builder addAllMap(Iterable<? extends Pair<Integer, String>> elements) {
            for (Pair<Integer, String> pair : elements) {
                this.map.add(Objects.requireNonNull(pair, "map element"));
            }
            return this;
        }

        public ImmutableVariableNames build() {
            return new ImmutableVariableNames(ImmutableVariableNames.createUnmodifiableList(true, this.map));
        }
    }

    @Generated(from="VariableNames", generator="Immutables")
    private final class InitShim {
        private byte nameHashMapBuildStage = 0;
        private Map<String, Integer> nameHashMap;
        private byte namesBuildStage = 0;
        private Set<String> names;

        private InitShim() {
        }

        Map<String, Integer> nameHashMap() {
            if (this.nameHashMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nameHashMapBuildStage == 0) {
                this.nameHashMapBuildStage = (byte)-1;
                this.nameHashMap = Objects.requireNonNull(ImmutableVariableNames.super.nameHashMap(), "nameHashMap");
                this.nameHashMapBuildStage = 1;
            }
            return this.nameHashMap;
        }

        Set<String> names() {
            if (this.namesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.namesBuildStage == 0) {
                this.namesBuildStage = (byte)-1;
                this.names = Objects.requireNonNull(ImmutableVariableNames.super.names(), "names");
                this.namesBuildStage = 1;
            }
            return this.names;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.nameHashMapBuildStage == -1) {
                attributes.add("nameHashMap");
            }
            if (this.namesBuildStage == -1) {
                attributes.add("names");
            }
            return "Cannot build VariableNames, attribute initializers form cycle " + attributes;
        }
    }
}

