/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.example;

import de.flapdoodle.eval.example.Value;
import de.flapdoodle.eval.example.ValueMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="ValueMap", generator="Immutables")
public final class ImmutableValueMap
extends ValueMap {
    private final Map<String, Value<?>> values;

    private ImmutableValueMap(Map<String, Value<?>> values) {
        this.values = values;
    }

    @Override
    protected Map<String, Value<?>> values() {
        return this.values;
    }

    public final ImmutableValueMap withValues(Map<String, ? extends Value<?>> entries) {
        if (this.values == entries) {
            return this;
        }
        Map<String, Value<?>> newValue = ImmutableValueMap.createUnmodifiableMap(true, false, entries);
        return new ImmutableValueMap(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValueMap && this.equalTo(0, (ImmutableValueMap)another);
    }

    private boolean equalTo(int synthetic, ImmutableValueMap another) {
        return this.values.equals(another.values);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.values.hashCode();
        return h;
    }

    public String toString() {
        return "ValueMap{values=" + this.values + "}";
    }

    public static ImmutableValueMap copyOf(ValueMap instance) {
        if (instance instanceof ImmutableValueMap) {
            return (ImmutableValueMap)instance;
        }
        return ImmutableValueMap.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ValueMap", generator="Immutables")
    public static final class Builder {
        private Map<String, Value<?>> values = new LinkedHashMap();

        private Builder() {
        }

        public final Builder from(ValueMap instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllValues(instance.values());
            return this;
        }

        public final Builder putValues(String key, Value<?> value) {
            this.values.put(Objects.requireNonNull(key, "values key"), value == null ? Objects.requireNonNull(value, "values value for key: " + key) : value);
            return this;
        }

        public final Builder putValues(Map.Entry<String, ? extends Value<?>> entry) {
            String k = entry.getKey();
            Value<?> v = entry.getValue();
            this.values.put(Objects.requireNonNull(k, "values key"), v == null ? Objects.requireNonNull(v, "values value for key: " + k) : v);
            return this;
        }

        public final Builder values(Map<String, ? extends Value<?>> entries) {
            this.values.clear();
            return this.putAllValues(entries);
        }

        public final Builder putAllValues(Map<String, ? extends Value<?>> entries) {
            for (Map.Entry<String, Value<?>> e : entries.entrySet()) {
                String k = e.getKey();
                Value<?> v = e.getValue();
                this.values.put(Objects.requireNonNull(k, "values key"), v == null ? Objects.requireNonNull(v, "values value for key: " + k) : v);
            }
            return this;
        }

        public ImmutableValueMap build() {
            return new ImmutableValueMap(ImmutableValueMap.createUnmodifiableMap(false, false, this.values));
        }
    }
}

