/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.example.evaluables.datetime;

import de.flapdoodle.eval.core.EvaluationContext;
import de.flapdoodle.eval.core.VariableResolver;
import de.flapdoodle.eval.core.evaluables.Parameter;
import de.flapdoodle.eval.core.evaluables.TypedEvaluable;
import de.flapdoodle.eval.core.evaluables.TypedEvaluables;
import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.core.validation.ParameterValidator;
import de.flapdoodle.eval.example.Value;
import de.flapdoodle.eval.example.evaluables.validation.NumberValidator;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class CreateLocalDateTime
extends TypedEvaluables.Wrapper {
    private static Value.DateTimeValue dateTimeValue(EvaluationContext evaluationContext, int year, int month, int day, int hour, int minute, int second, int nanoOfs) {
        ZoneId zoneId = evaluationContext.zoneId();
        return Value.of(LocalDateTime.of(year, month, day, hour, minute, second, nanoOfs).atZone(zoneId).toInstant());
    }

    public CreateLocalDateTime() {
        super(TypedEvaluables.builder().addList((TypedEvaluable<?>)TypedEvaluable.of(Value.DateTimeValue.class, Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.year()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.month()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.dayOfMonth()), new With3Args())).addList((TypedEvaluable<?>)TypedEvaluable.of(Value.DateTimeValue.class, Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.year()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.month()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.dayOfMonth()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.hourOfDay()), new With4Args())).addList((TypedEvaluable<?>)TypedEvaluable.of(Value.DateTimeValue.class, Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.year()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.month()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.dayOfMonth()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.hourOfDay()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.minutes()), new With5Args())).addList((TypedEvaluable<?>)TypedEvaluable.of(Value.DateTimeValue.class, Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.year()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.month()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.dayOfMonth()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.hourOfDay()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.minutes()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.seconds()), new With6Args())).addList((TypedEvaluable<?>)TypedEvaluable.of(Value.DateTimeValue.class, Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.year()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.month()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.dayOfMonth()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.hourOfDay()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.minutes()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.seconds()), Parameter.of(Value.NumberValue.class).withValidators(CreateLocalDateTime.nano()), new With7Args())).build());
    }

    private static ParameterValidator<Value.NumberValue> year() {
        return NumberValidator.between(0L, 9999L);
    }

    private static ParameterValidator<Value.NumberValue> month() {
        return NumberValidator.between(1L, 12L);
    }

    private static ParameterValidator<Value.NumberValue> dayOfMonth() {
        return NumberValidator.between(1L, 31L);
    }

    private static ParameterValidator<Value.NumberValue> hourOfDay() {
        return NumberValidator.between(0L, 23L);
    }

    private static ParameterValidator<Value.NumberValue> minutes() {
        return NumberValidator.between(0L, 59L);
    }

    private static ParameterValidator<Value.NumberValue> seconds() {
        return NumberValidator.between(0L, 59L);
    }

    private static ParameterValidator<Value.NumberValue> nano() {
        return NumberValidator.between(0L, 999999999L);
    }

    public static class With7Args
    implements TypedEvaluable.Arg7<Value.NumberValue, Value.NumberValue, Value.NumberValue, Value.NumberValue, Value.NumberValue, Value.NumberValue, Value.NumberValue, Value.DateTimeValue> {
        @Override
        public Value.DateTimeValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.NumberValue year, Value.NumberValue month, Value.NumberValue day, Value.NumberValue hour, Value.NumberValue minute, Value.NumberValue second, Value.NumberValue nano) throws EvaluationException {
            return CreateLocalDateTime.dateTimeValue(evaluationContext, ((BigDecimal)year.wrapped()).intValue(), ((BigDecimal)month.wrapped()).intValue(), ((BigDecimal)day.wrapped()).intValue(), ((BigDecimal)hour.wrapped()).intValue(), ((BigDecimal)minute.wrapped()).intValue(), ((BigDecimal)second.wrapped()).intValue(), ((BigDecimal)nano.wrapped()).intValue());
        }
    }

    public static class With6Args
    implements TypedEvaluable.Arg6<Value.NumberValue, Value.NumberValue, Value.NumberValue, Value.NumberValue, Value.NumberValue, Value.NumberValue, Value.DateTimeValue> {
        @Override
        public Value.DateTimeValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.NumberValue year, Value.NumberValue month, Value.NumberValue day, Value.NumberValue hour, Value.NumberValue minute, Value.NumberValue second) throws EvaluationException {
            return CreateLocalDateTime.dateTimeValue(evaluationContext, ((BigDecimal)year.wrapped()).intValue(), ((BigDecimal)month.wrapped()).intValue(), ((BigDecimal)day.wrapped()).intValue(), ((BigDecimal)hour.wrapped()).intValue(), ((BigDecimal)minute.wrapped()).intValue(), ((BigDecimal)second.wrapped()).intValue(), 0);
        }
    }

    public static class With5Args
    implements TypedEvaluable.Arg5<Value.NumberValue, Value.NumberValue, Value.NumberValue, Value.NumberValue, Value.NumberValue, Value.DateTimeValue> {
        @Override
        public Value.DateTimeValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.NumberValue year, Value.NumberValue month, Value.NumberValue day, Value.NumberValue hour, Value.NumberValue minute) throws EvaluationException {
            return CreateLocalDateTime.dateTimeValue(evaluationContext, ((BigDecimal)year.wrapped()).intValue(), ((BigDecimal)month.wrapped()).intValue(), ((BigDecimal)day.wrapped()).intValue(), ((BigDecimal)hour.wrapped()).intValue(), ((BigDecimal)minute.wrapped()).intValue(), 0, 0);
        }
    }

    public static class With4Args
    implements TypedEvaluable.Arg4<Value.NumberValue, Value.NumberValue, Value.NumberValue, Value.NumberValue, Value.DateTimeValue> {
        @Override
        public Value.DateTimeValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.NumberValue year, Value.NumberValue month, Value.NumberValue day, Value.NumberValue hour) throws EvaluationException {
            return CreateLocalDateTime.dateTimeValue(evaluationContext, ((BigDecimal)year.wrapped()).intValue(), ((BigDecimal)month.wrapped()).intValue(), ((BigDecimal)day.wrapped()).intValue(), ((BigDecimal)hour.wrapped()).intValue(), 0, 0, 0);
        }
    }

    public static class With3Args
    implements TypedEvaluable.Arg3<Value.NumberValue, Value.NumberValue, Value.NumberValue, Value.DateTimeValue> {
        @Override
        public Value.DateTimeValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.NumberValue first, Value.NumberValue second, Value.NumberValue third) throws EvaluationException {
            return CreateLocalDateTime.dateTimeValue(evaluationContext, ((BigDecimal)first.wrapped()).intValue(), ((BigDecimal)second.wrapped()).intValue(), ((BigDecimal)third.wrapped()).intValue(), 0, 0, 0, 0);
        }
    }
}

