package de.flapdoodle.eval.core;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MapBasedVariableResolver}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMapBasedVariableResolver.builder()}.
 */
@Generated(from = "MapBasedVariableResolver", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableMapBasedVariableResolver extends MapBasedVariableResolver {
  private final Map<String, Object> variables;

  private ImmutableMapBasedVariableResolver(Map<String, Object> variables) {
    this.variables = variables;
  }

  /**
   * @return The value of the {@code variables} attribute
   */
  @Override
  protected Map<String, Object> variables() {
    return variables;
  }

  /**
   * Copy the current immutable object by replacing the {@link MapBasedVariableResolver#variables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMapBasedVariableResolver withVariables(Map<String, ? extends Object> entries) {
    if (this.variables == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableMapBasedVariableResolver(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMapBasedVariableResolver} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMapBasedVariableResolver
        && equalTo(0, (ImmutableMapBasedVariableResolver) another);
  }

  private boolean equalTo(int synthetic, ImmutableMapBasedVariableResolver another) {
    return variables.equals(another.variables);
  }

  /**
   * Computes a hash code from attributes: {@code variables}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + variables.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MapBasedVariableResolver} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MapBasedVariableResolver{"
        + "variables=" + variables
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MapBasedVariableResolver} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MapBasedVariableResolver instance
   */
  public static ImmutableMapBasedVariableResolver copyOf(MapBasedVariableResolver instance) {
    if (instance instanceof ImmutableMapBasedVariableResolver) {
      return (ImmutableMapBasedVariableResolver) instance;
    }
    return ImmutableMapBasedVariableResolver.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMapBasedVariableResolver ImmutableMapBasedVariableResolver}.
   * <pre>
   * ImmutableMapBasedVariableResolver.builder()
   *    .putVariables|putAllVariables(String =&gt; Object) // {@link MapBasedVariableResolver#variables() variables} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableMapBasedVariableResolver builder
   */
  public static ImmutableMapBasedVariableResolver.Builder builder() {
    return new ImmutableMapBasedVariableResolver.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMapBasedVariableResolver ImmutableMapBasedVariableResolver}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MapBasedVariableResolver", generator = "Immutables")
  public static final class Builder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MapBasedVariableResolver} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MapBasedVariableResolver instance) {
      Objects.requireNonNull(instance, "instance");
      putAllVariables(instance.variables());
      return this;
    }

    /**
     * Put one entry to the {@link MapBasedVariableResolver#variables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariables(String key, Object value) {
      this.variables.put(
          Objects.requireNonNull(key, "variables key"),
          value == null ? Objects.requireNonNull(value, "variables value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link MapBasedVariableResolver#variables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariables(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.variables.put(
          Objects.requireNonNull(k, "variables key"),
          v == null ? Objects.requireNonNull(v, "variables value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MapBasedVariableResolver#variables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder variables(Map<String, ? extends Object> entries) {
      this.variables.clear();
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MapBasedVariableResolver#variables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.variables.put(
            Objects.requireNonNull(k, "variables key"),
            v == null ? Objects.requireNonNull(v, "variables value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableMapBasedVariableResolver ImmutableMapBasedVariableResolver}.
     * @return An immutable instance of MapBasedVariableResolver
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMapBasedVariableResolver build() {
      return new ImmutableMapBasedVariableResolver(createUnmodifiableMap(false, false, variables));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
