package de.flapdoodle.eval.core.evaluables;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OperatorMap}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOperatorMap.builder()}.
 */
@Generated(from = "OperatorMap", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableOperatorMap extends OperatorMap {
  private final Map<String, OperatorMapping> prefix;
  private final Map<String, OperatorMapping> infix;
  private final Map<String, OperatorMapping> postfix;

  private ImmutableOperatorMap(
      Map<String, OperatorMapping> prefix,
      Map<String, OperatorMapping> infix,
      Map<String, OperatorMapping> postfix) {
    this.prefix = prefix;
    this.infix = infix;
    this.postfix = postfix;
  }

  /**
   * @return The value of the {@code prefix} attribute
   */
  @Override
  protected Map<String, OperatorMapping> prefix() {
    return prefix;
  }

  /**
   * @return The value of the {@code infix} attribute
   */
  @Override
  protected Map<String, OperatorMapping> infix() {
    return infix;
  }

  /**
   * @return The value of the {@code postfix} attribute
   */
  @Override
  protected Map<String, OperatorMapping> postfix() {
    return postfix;
  }

  /**
   * Copy the current immutable object by replacing the {@link OperatorMap#prefix() prefix} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the prefix map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperatorMap withPrefix(Map<String, ? extends OperatorMapping> entries) {
    if (this.prefix == entries) return this;
    Map<String, OperatorMapping> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableOperatorMap(newValue, this.infix, this.postfix);
  }

  /**
   * Copy the current immutable object by replacing the {@link OperatorMap#infix() infix} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the infix map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperatorMap withInfix(Map<String, ? extends OperatorMapping> entries) {
    if (this.infix == entries) return this;
    Map<String, OperatorMapping> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableOperatorMap(this.prefix, newValue, this.postfix);
  }

  /**
   * Copy the current immutable object by replacing the {@link OperatorMap#postfix() postfix} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the postfix map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperatorMap withPostfix(Map<String, ? extends OperatorMapping> entries) {
    if (this.postfix == entries) return this;
    Map<String, OperatorMapping> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableOperatorMap(this.prefix, this.infix, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOperatorMap} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOperatorMap
        && equalTo(0, (ImmutableOperatorMap) another);
  }

  private boolean equalTo(int synthetic, ImmutableOperatorMap another) {
    return prefix.equals(another.prefix)
        && infix.equals(another.infix)
        && postfix.equals(another.postfix);
  }

  /**
   * Computes a hash code from attributes: {@code prefix}, {@code infix}, {@code postfix}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + prefix.hashCode();
    h += (h << 5) + infix.hashCode();
    h += (h << 5) + postfix.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OperatorMap} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OperatorMap{"
        + "prefix=" + prefix
        + ", infix=" + infix
        + ", postfix=" + postfix
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link OperatorMap} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OperatorMap instance
   */
  public static ImmutableOperatorMap copyOf(OperatorMap instance) {
    if (instance instanceof ImmutableOperatorMap) {
      return (ImmutableOperatorMap) instance;
    }
    return ImmutableOperatorMap.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOperatorMap ImmutableOperatorMap}.
   * <pre>
   * ImmutableOperatorMap.builder()
   *    .putPrefix|putAllPrefix(String =&gt; de.flapdoodle.eval.core.evaluables.OperatorMapping) // {@link OperatorMap#prefix() prefix} mappings
   *    .putInfix|putAllInfix(String =&gt; de.flapdoodle.eval.core.evaluables.OperatorMapping) // {@link OperatorMap#infix() infix} mappings
   *    .putPostfix|putAllPostfix(String =&gt; de.flapdoodle.eval.core.evaluables.OperatorMapping) // {@link OperatorMap#postfix() postfix} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableOperatorMap builder
   */
  public static ImmutableOperatorMap.Builder builder() {
    return new ImmutableOperatorMap.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOperatorMap ImmutableOperatorMap}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OperatorMap", generator = "Immutables")
  public static final class Builder {
    private Map<String, OperatorMapping> prefix = new LinkedHashMap<String, OperatorMapping>();
    private Map<String, OperatorMapping> infix = new LinkedHashMap<String, OperatorMapping>();
    private Map<String, OperatorMapping> postfix = new LinkedHashMap<String, OperatorMapping>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OperatorMap} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OperatorMap instance) {
      Objects.requireNonNull(instance, "instance");
      putAllPrefix(instance.prefix());
      putAllInfix(instance.infix());
      putAllPostfix(instance.postfix());
      return this;
    }

    /**
     * Put one entry to the {@link OperatorMap#prefix() prefix} map.
     * @param key The key in the prefix map
     * @param value The associated value in the prefix map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putPrefix(String key, OperatorMapping value) {
      this.prefix.put(
          Objects.requireNonNull(key, "prefix key"),
          value == null ? Objects.requireNonNull(value, "prefix value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link OperatorMap#prefix() prefix} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putPrefix(Map.Entry<String, ? extends OperatorMapping> entry) {
      String k = entry.getKey();
      OperatorMapping v = entry.getValue();
      this.prefix.put(
          Objects.requireNonNull(k, "prefix key"),
          v == null ? Objects.requireNonNull(v, "prefix value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link OperatorMap#prefix() prefix} map. Nulls are not permitted
     * @param entries The entries that will be added to the prefix map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder prefix(Map<String, ? extends OperatorMapping> entries) {
      this.prefix.clear();
      return putAllPrefix(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link OperatorMap#prefix() prefix} map. Nulls are not permitted
     * @param entries The entries that will be added to the prefix map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllPrefix(Map<String, ? extends OperatorMapping> entries) {
      for (Map.Entry<String, ? extends OperatorMapping> e : entries.entrySet()) {
        String k = e.getKey();
        OperatorMapping v = e.getValue();
        this.prefix.put(
            Objects.requireNonNull(k, "prefix key"),
            v == null ? Objects.requireNonNull(v, "prefix value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link OperatorMap#infix() infix} map.
     * @param key The key in the infix map
     * @param value The associated value in the infix map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putInfix(String key, OperatorMapping value) {
      this.infix.put(
          Objects.requireNonNull(key, "infix key"),
          value == null ? Objects.requireNonNull(value, "infix value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link OperatorMap#infix() infix} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putInfix(Map.Entry<String, ? extends OperatorMapping> entry) {
      String k = entry.getKey();
      OperatorMapping v = entry.getValue();
      this.infix.put(
          Objects.requireNonNull(k, "infix key"),
          v == null ? Objects.requireNonNull(v, "infix value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link OperatorMap#infix() infix} map. Nulls are not permitted
     * @param entries The entries that will be added to the infix map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder infix(Map<String, ? extends OperatorMapping> entries) {
      this.infix.clear();
      return putAllInfix(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link OperatorMap#infix() infix} map. Nulls are not permitted
     * @param entries The entries that will be added to the infix map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllInfix(Map<String, ? extends OperatorMapping> entries) {
      for (Map.Entry<String, ? extends OperatorMapping> e : entries.entrySet()) {
        String k = e.getKey();
        OperatorMapping v = e.getValue();
        this.infix.put(
            Objects.requireNonNull(k, "infix key"),
            v == null ? Objects.requireNonNull(v, "infix value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link OperatorMap#postfix() postfix} map.
     * @param key The key in the postfix map
     * @param value The associated value in the postfix map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putPostfix(String key, OperatorMapping value) {
      this.postfix.put(
          Objects.requireNonNull(key, "postfix key"),
          value == null ? Objects.requireNonNull(value, "postfix value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link OperatorMap#postfix() postfix} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putPostfix(Map.Entry<String, ? extends OperatorMapping> entry) {
      String k = entry.getKey();
      OperatorMapping v = entry.getValue();
      this.postfix.put(
          Objects.requireNonNull(k, "postfix key"),
          v == null ? Objects.requireNonNull(v, "postfix value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link OperatorMap#postfix() postfix} map. Nulls are not permitted
     * @param entries The entries that will be added to the postfix map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder postfix(Map<String, ? extends OperatorMapping> entries) {
      this.postfix.clear();
      return putAllPostfix(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link OperatorMap#postfix() postfix} map. Nulls are not permitted
     * @param entries The entries that will be added to the postfix map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllPostfix(Map<String, ? extends OperatorMapping> entries) {
      for (Map.Entry<String, ? extends OperatorMapping> e : entries.entrySet()) {
        String k = e.getKey();
        OperatorMapping v = e.getValue();
        this.postfix.put(
            Objects.requireNonNull(k, "postfix key"),
            v == null ? Objects.requireNonNull(v, "postfix value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableOperatorMap ImmutableOperatorMap}.
     * @return An immutable instance of OperatorMap
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOperatorMap build() {
      return new ImmutableOperatorMap(
          createUnmodifiableMap(false, false, prefix),
          createUnmodifiableMap(false, false, infix),
          createUnmodifiableMap(false, false, postfix));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
