package de.flapdoodle.eval.core.tree;

import de.flapdoodle.eval.core.parser.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LookupNode}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLookupNode.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableLookupNode.of()}.
 */
@Generated(from = "LookupNode", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableLookupNode extends LookupNode {
  private final Token token;

  private ImmutableLookupNode(Token token) {
    this.token = Objects.requireNonNull(token, "token");
  }

  private ImmutableLookupNode(ImmutableLookupNode original, Token token) {
    this.token = token;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @Override
  public Token token() {
    return token;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LookupNode#token() token} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLookupNode withToken(Token value) {
    if (this.token == value) return this;
    Token newValue = Objects.requireNonNull(value, "token");
    return new ImmutableLookupNode(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLookupNode} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLookupNode
        && equalTo(0, (ImmutableLookupNode) another);
  }

  private boolean equalTo(int synthetic, ImmutableLookupNode another) {
    return token.equals(another.token);
  }

  /**
   * Computes a hash code from attributes: {@code token}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + token.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LookupNode} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LookupNode{"
        + "token=" + token
        + "}";
  }

  /**
   * Construct a new immutable {@code LookupNode} instance.
   * @param token The value for the {@code token} attribute
   * @return An immutable LookupNode instance
   */
  public static ImmutableLookupNode of(Token token) {
    return new ImmutableLookupNode(token);
  }

  /**
   * Creates an immutable copy of a {@link LookupNode} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LookupNode instance
   */
  public static ImmutableLookupNode copyOf(LookupNode instance) {
    if (instance instanceof ImmutableLookupNode) {
      return (ImmutableLookupNode) instance;
    }
    return ImmutableLookupNode.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLookupNode ImmutableLookupNode}.
   * <pre>
   * ImmutableLookupNode.builder()
   *    .token(de.flapdoodle.eval.core.parser.Token) // required {@link LookupNode#token() token}
   *    .build();
   * </pre>
   * @return A new ImmutableLookupNode builder
   */
  public static ImmutableLookupNode.Builder builder() {
    return new ImmutableLookupNode.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLookupNode ImmutableLookupNode}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LookupNode", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_TOKEN = 0x1L;
    private long initBits = 0x1L;

    private Token token;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.eval.core.tree.Node} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Node instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.eval.core.tree.LookupNode} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(LookupNode instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Node) {
        Node instance = (Node) object;
        token(instance.token());
      }
    }

    /**
     * Initializes the value for the {@link LookupNode#token() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder token(Token token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLookupNode ImmutableLookupNode}.
     * @return An immutable instance of LookupNode
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLookupNode build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLookupNode(null, token);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TOKEN) != 0) attributes.add("token");
      return "Cannot build LookupNode, some of required attributes are not set " + attributes;
    }
  }
}
