package de.flapdoodle.eval.example;

import de.flapdoodle.eval.core.exceptions.EvaluationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Value.FailedWithException}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFailedWithException.builder()}.
 */
@Generated(from = "Value.FailedWithException", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableFailedWithException<T>
    extends Value.FailedWithException<T> {
  private final EvaluationException exception;

  private ImmutableFailedWithException(EvaluationException exception) {
    this.exception = exception;
  }

  /**
   * @return The value of the {@code exception} attribute
   */
  @Override
  public EvaluationException exception() {
    return exception;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Value.FailedWithException#exception() exception} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for exception
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFailedWithException<T> withException(EvaluationException value) {
    if (this.exception == value) return this;
    EvaluationException newValue = Objects.requireNonNull(value, "exception");
    return new ImmutableFailedWithException<>(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFailedWithException} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFailedWithException<?>
        && equalTo(0, (ImmutableFailedWithException<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableFailedWithException<?> another) {
    return exception.equals(another.exception);
  }

  /**
   * Computes a hash code from attributes: {@code exception}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + exception.hashCode();
    return h;
  }

  private transient volatile long lazyInitBitmap;

  private static final long WRAPPED_LAZY_INIT_BIT = 0x1L;

  private transient T wrapped;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Value.FailedWithException#wrapped() wrapped} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code wrapped} attribute
   */
  @Override
  public T wrapped() {
    if ((lazyInitBitmap & WRAPPED_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & WRAPPED_LAZY_INIT_BIT) == 0) {
          this.wrapped = super.wrapped();
          lazyInitBitmap |= WRAPPED_LAZY_INIT_BIT;
        }
      }
    }
    return wrapped;
  }

  /**
   * Creates an immutable copy of a {@link Value.FailedWithException} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable FailedWithException instance
   */
  public static <T> ImmutableFailedWithException<T> copyOf(Value.FailedWithException<T> instance) {
    if (instance instanceof ImmutableFailedWithException<?>) {
      return (ImmutableFailedWithException<T>) instance;
    }
    return ImmutableFailedWithException.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFailedWithException ImmutableFailedWithException}.
   * <pre>
   * ImmutableFailedWithException.&amp;lt;T&amp;gt;builder()
   *    .exception(de.flapdoodle.eval.core.exceptions.EvaluationException) // required {@link Value.FailedWithException#exception() exception}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableFailedWithException builder
   */
  public static <T> ImmutableFailedWithException.Builder<T> builder() {
    return new ImmutableFailedWithException.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableFailedWithException ImmutableFailedWithException}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Value.FailedWithException", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_EXCEPTION = 0x1L;
    private long initBits = 0x1L;

    private EvaluationException exception;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FailedWithException} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(Value.FailedWithException<T> instance) {
      Objects.requireNonNull(instance, "instance");
      exception(instance.exception());
      return this;
    }

    /**
     * Initializes the value for the {@link Value.FailedWithException#exception() exception} attribute.
     * @param exception The value for exception 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> exception(EvaluationException exception) {
      this.exception = Objects.requireNonNull(exception, "exception");
      initBits &= ~INIT_BIT_EXCEPTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFailedWithException ImmutableFailedWithException}.
     * @return An immutable instance of FailedWithException
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFailedWithException<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFailedWithException<>(exception);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EXCEPTION) != 0) attributes.add("exception");
      return "Cannot build FailedWithException, some of required attributes are not set " + attributes;
    }
  }
}
