package de.flapdoodle.eval.example;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Values}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValues.builder()}.
 */
@Generated(from = "Values", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableValues extends Values {
  private final List<Value<?>> values;

  private ImmutableValues(List<Value<?>> values) {
    this.values = values;
  }

  /**
   * @return The value of the {@code values} attribute
   */
  @Override
  protected List<Value<?>> values() {
    return values;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Values#values() values}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableValues withValues(Value<?>... elements) {
    List<Value<?>> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableValues(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Values#values() values}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of values elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValues withValues(Iterable<? extends Value<?>> elements) {
    if (this.values == elements) return this;
    List<Value<?>> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableValues(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValues} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValues
        && equalTo(0, (ImmutableValues) another);
  }

  private boolean equalTo(int synthetic, ImmutableValues another) {
    return values.equals(another.values);
  }

  /**
   * Computes a hash code from attributes: {@code values}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + values.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Values} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Values{"
        + "values=" + values
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Values} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Values instance
   */
  public static ImmutableValues copyOf(Values instance) {
    if (instance instanceof ImmutableValues) {
      return (ImmutableValues) instance;
    }
    return ImmutableValues.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValues ImmutableValues}.
   * <pre>
   * ImmutableValues.builder()
   *    .addValues|addAllValues(de.flapdoodle.eval.example.Value&amp;lt;?&amp;gt;) // {@link Values#values() values} elements
   *    .build();
   * </pre>
   * @return A new ImmutableValues builder
   */
  public static ImmutableValues.Builder builder() {
    return new ImmutableValues.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValues ImmutableValues}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Values", generator = "Immutables")
  public static final class Builder {
    private List<Value<?>> values = new ArrayList<Value<?>>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Values} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Values instance) {
      Objects.requireNonNull(instance, "instance");
      addAllValues(instance.values());
      return this;
    }

    /**
     * Adds one element to {@link Values#values() values} list.
     * @param element A values element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addValues(Value<?> element) {
      this.values.add(Objects.requireNonNull(element, "values element"));
      return this;
    }

    /**
     * Adds elements to {@link Values#values() values} list.
     * @param elements An array of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addValues(Value<?>... elements) {
      for (Value<?> element : elements) {
        this.values.add(Objects.requireNonNull(element, "values element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Values#values() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder values(Iterable<? extends Value<?>> elements) {
      this.values.clear();
      return addAllValues(elements);
    }

    /**
     * Adds elements to {@link Values#values() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllValues(Iterable<? extends Value<?>> elements) {
      for (Value<?> element : elements) {
        this.values.add(Objects.requireNonNull(element, "values element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableValues ImmutableValues}.
     * @return An immutable instance of Values
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValues build() {
      return new ImmutableValues(createUnmodifiableList(true, values));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
