/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core;

import de.flapdoodle.eval.core.ImmutableMapBasedVariableResolver;
import de.flapdoodle.eval.core.VariableResolver;
import java.util.Map;
import org.immutables.value.Value;

@Value.Immutable
public abstract class MapBasedVariableResolver
implements VariableResolver {
    protected abstract Map<String, Object> variables();

    @Override
    @Value.Auxiliary
    public Object get(String variable) {
        return this.variables().get(variable);
    }

    @Value.Auxiliary
    public ImmutableMapBasedVariableResolver with(String variable, Object value) {
        return MapBasedVariableResolver.builder().from(this).putVariables(variable, value).build();
    }

    @Value.Auxiliary
    public ImmutableMapBasedVariableResolver and(String variable, Object value) {
        return this.with(variable, value);
    }

    @Value.Auxiliary
    public ImmutableMapBasedVariableResolver withValues(Map<String, ?> values) {
        ImmutableMapBasedVariableResolver.Builder builder = MapBasedVariableResolver.builder().from(this);
        for (Map.Entry<String, ?> entry : values.entrySet()) {
            builder.putVariables(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    public static ImmutableMapBasedVariableResolver.Builder builder() {
        return ImmutableMapBasedVariableResolver.builder();
    }

    public static ImmutableMapBasedVariableResolver empty() {
        return MapBasedVariableResolver.builder().build();
    }
}

