/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.evaluables;

import de.flapdoodle.eval.core.evaluables.ImmutableSignature;
import de.flapdoodle.eval.core.evaluables.Parameter;
import de.flapdoodle.eval.core.exceptions.EvaluableException;
import java.util.List;
import java.util.Optional;
import org.immutables.builder.Builder;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Signature<T> {
    public abstract List<Parameter<?>> parameters();

    @Value.Default
    public boolean isVarArg() {
        return false;
    }

    @Builder.Parameter
    public abstract Class<T> returnType();

    @Value.Derived
    public int minNumberOfArguments() {
        return this.parameters().size();
    }

    @Value.Derived
    public int maxNumberOfArguments() {
        return this.isVarArg() ? Integer.MAX_VALUE : this.parameters().size();
    }

    @Value.Auxiliary
    public Parameter<?> get(int index) {
        if (this.isVarArg() && index >= this.parameters().size()) {
            index = this.parameters().size() - 1;
        }
        return this.parameters().get(index);
    }

    @Value.Auxiliary
    public Optional<EvaluableException> validateArguments(List<?> arguments) {
        Optional<EvaluableException> error;
        if (this.minNumberOfArguments() > arguments.size()) {
            return Optional.of(EvaluableException.of("not enough(<%s) arguments: %s", this.minNumberOfArguments(), arguments.size()));
        }
        if (arguments.size() > this.maxNumberOfArguments()) {
            return Optional.of(EvaluableException.of("to many(>%s) arguments: ", this.maxNumberOfArguments(), arguments.size()));
        }
        for (int i = 0; i < this.minNumberOfArguments(); ++i) {
            Object value = arguments.get(i);
            Parameter<?> parameter = this.get(i);
            Class<?> type = parameter.type();
            if (!type.isInstance(value)) {
                return Optional.of(EvaluableException.of("wrong type: %s != %s (%s)", type, value.getClass(), value));
            }
            error = parameter.validationError(value);
            if (!error.isPresent()) continue;
            return error;
        }
        if (this.isVarArg()) {
            Parameter<?> parameter = this.get(this.minNumberOfArguments() - 1);
            Class<?> type = parameter.type();
            for (int i = this.minNumberOfArguments() + 1; i < arguments.size(); ++i) {
                Object value = arguments.get(i);
                if (!type.isInstance(value)) {
                    return Optional.of(EvaluableException.of("wrong type: %s != %s (%s)", type, value.getClass(), value));
                }
                error = parameter.validationError(value);
                if (!error.isPresent()) continue;
                return error;
            }
        }
        return Optional.empty();
    }

    public static <T> Signature<T> of(Class<T> returnType, List<? extends Parameter<?>> parameters) {
        return ImmutableSignature.builder(returnType).addAllParameters(parameters).build();
    }

    public static <T> Signature<T> of(Class<T> returnType, Parameter<?> ... parameters) {
        return ImmutableSignature.builder(returnType).addParameters(parameters).build();
    }

    public static <T> Signature<T> ofVarArg(Class<T> returnType, Parameter<?> ... parameters) {
        return ImmutableSignature.builder(returnType).addParameters(parameters).isVarArg(true).build();
    }
}

