/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.exceptions;

import de.flapdoodle.eval.core.exceptions.BaseException;
import de.flapdoodle.eval.core.exceptions.EvaluableException;
import de.flapdoodle.eval.core.parser.Token;
import java.util.List;

public class EvaluationException
extends BaseException {
    public EvaluationException(Token token, String message) {
        super(token.start(), token.start() + token.value().length(), token.value(), message);
    }

    public EvaluationException(Token token, EvaluableException cause) {
        super(token.start(), token.start() + token.value().length(), token.value(), cause);
    }

    public EvaluationException of(Token token, List<? extends EvaluableException> causes) {
        EvaluableException cause = causes.get(0);
        for (int i = 1; i < causes.size(); ++i) {
            EvaluableException c = causes.get(i);
            cause.addSuppressed(c);
        }
        return new EvaluationException(token, cause);
    }

    public static EvaluationException ofUnsupportedDataTypeInOperation(Token token) {
        return new EvaluationException(token, "Unsupported data types in operation");
    }

    public static class AsRuntimeException
    extends RuntimeException {
        private final EvaluationException wrapped;

        public AsRuntimeException(EvaluationException wrapped) {
            this.wrapped = wrapped;
        }

        public EvaluationException wrapped() {
            return this.wrapped;
        }
    }
}

