/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.parser;

import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.core.parser.TokenType;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="Token", generator="Immutables")
public final class ImmutableToken
implements Token {
    private final int start;
    private final String value;
    private final TokenType type;

    private ImmutableToken(int start, String value, TokenType type) {
        this.start = start;
        this.value = Objects.requireNonNull(value, "value");
        this.type = Objects.requireNonNull(type, "type");
    }

    private ImmutableToken(ImmutableToken original, int start, String value, TokenType type) {
        this.start = start;
        this.value = value;
        this.type = type;
    }

    @Override
    public int start() {
        return this.start;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public TokenType type() {
        return this.type;
    }

    public final ImmutableToken withStart(int value) {
        if (this.start == value) {
            return this;
        }
        return new ImmutableToken(this, value, this.value, this.type);
    }

    public final ImmutableToken withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableToken(this, this.start, newValue, this.type);
    }

    public final ImmutableToken withType(TokenType value) {
        TokenType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableToken(this, this.start, this.value, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToken && this.equalTo(0, (ImmutableToken)another);
    }

    private boolean equalTo(int synthetic, ImmutableToken another) {
        return this.start == another.start && this.value.equals(another.value) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.start;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "Token{start=" + this.start + ", value=" + this.value + ", type=" + (Object)((Object)this.type) + "}";
    }

    public static ImmutableToken of(int start, String value, TokenType type) {
        return new ImmutableToken(start, value, type);
    }

    public static ImmutableToken copyOf(Token instance) {
        if (instance instanceof ImmutableToken) {
            return (ImmutableToken)instance;
        }
        return ImmutableToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Token", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_START = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private long initBits = 7L;
        private int start;
        private String value;
        private TokenType type;

        private Builder() {
        }

        public final Builder from(Token instance) {
            Objects.requireNonNull(instance, "instance");
            this.start(instance.start());
            this.value(instance.value());
            this.type(instance.type());
            return this;
        }

        public final Builder start(int start) {
            this.start = start;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder type(TokenType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableToken(null, this.start, this.value, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("start");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build Token, some of required attributes are not set " + attributes;
        }
    }
}

