/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.tree;

import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.core.tree.EvaluableExceptionMapper;
import de.flapdoodle.eval.core.tree.ImmutableEvalFailedWithException;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class EvalFailedWithException {
    public abstract EvaluationException exception();

    public static EvalFailedWithException of(EvaluationException exception) {
        return ImmutableEvalFailedWithException.builder().exception(exception).build();
    }

    public static EvaluableExceptionMapper mapper() {
        return new EvaluableExceptionMapper(){

            @Override
            public Object map(EvaluationException ex) {
                return EvalFailedWithException.of(ex);
            }

            @Override
            public Optional<EvaluationException> match(Object value) {
                return value instanceof EvalFailedWithException ? Optional.of(((EvalFailedWithException)value).exception()) : Optional.empty();
            }
        };
    }
}

