/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.tree;

import de.flapdoodle.eval.core.EvaluationContext;
import de.flapdoodle.eval.core.VariableResolver;
import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.core.tree.EvaluatableNode;
import de.flapdoodle.eval.core.tree.ImmutableVariableNames;
import de.flapdoodle.eval.core.tree.LookupNode;
import de.flapdoodle.eval.core.tree.VariableNames;
import de.flapdoodle.types.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;

public abstract class Node {
    @Value.Parameter
    public abstract Token token();

    @Value.Auxiliary
    public abstract Object evaluate(VariableResolver var1, EvaluationContext var2) throws EvaluationException;

    public static List<Node> allNodes(Node node) {
        ArrayList<Node> ret = new ArrayList<Node>();
        ret.add(node);
        List<Node> subnodes = Collections.emptyList();
        if (node instanceof EvaluatableNode) {
            subnodes = ((EvaluatableNode)node).parameters();
        }
        subnodes.forEach(subNode -> ret.addAll(Node.allNodes(subNode)));
        return ret;
    }

    @Deprecated
    public static Set<String> usedVariables(List<Node> nodes) {
        return nodes.stream().filter(it -> it instanceof LookupNode).map(it -> it.token().value()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Deprecated
    public static Set<String> usedVariables(Node node) {
        return Node.usedVariables(Node.allNodes(node));
    }

    public static VariableNames hashedUsedVariables(String expression, Node root) {
        ArrayList<Pair<Integer, String>> entries = new ArrayList<Pair<Integer, String>>();
        Node.hashedUsedVariables(entries, 0, expression, root);
        ImmutableVariableNames.Builder builder = VariableNames.builder();
        builder.addAllMap(entries);
        return builder.build();
    }

    private static int hashedUsedVariables(List<Pair<Integer, String>> entries, int lastTokenEnd, String expression, Node root) {
        if (root instanceof LookupNode) {
            Token token = root.token();
            String expressionBetweenTokens = expression.substring(lastTokenEnd, token.start());
            entries.add((Pair<Integer, String>)Pair.of((Object)(entries.size() + ":" + expressionBetweenTokens).hashCode(), (Object)token.value()));
            lastTokenEnd = token.start() + token.value().length();
        } else if (root instanceof EvaluatableNode) {
            for (Node it : ((EvaluatableNode)root).parameters()) {
                lastTokenEnd = Node.hashedUsedVariables(entries, lastTokenEnd, expression, it);
            }
        }
        return lastTokenEnd;
    }
}

