/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.example;

import de.flapdoodle.eval.example.Value;
import de.flapdoodle.eval.example.Values;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="Values", generator="Immutables")
public final class ImmutableValues
extends Values {
    private final List<Value<?>> values;

    private ImmutableValues(List<Value<?>> values) {
        this.values = values;
    }

    @Override
    protected List<Value<?>> values() {
        return this.values;
    }

    @SafeVarargs
    public final ImmutableValues withValues(Value<?> ... elements) {
        List<Value<?>> newValue = ImmutableValues.createUnmodifiableList(false, ImmutableValues.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableValues(newValue);
    }

    public final ImmutableValues withValues(Iterable<? extends Value<?>> elements) {
        if (this.values == elements) {
            return this;
        }
        List<Value<?>> newValue = ImmutableValues.createUnmodifiableList(false, ImmutableValues.createSafeList(elements, true, false));
        return new ImmutableValues(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValues && this.equalTo(0, (ImmutableValues)another);
    }

    private boolean equalTo(int synthetic, ImmutableValues another) {
        return this.values.equals(another.values);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.values.hashCode();
        return h;
    }

    public String toString() {
        return "Values{values=" + this.values + "}";
    }

    public static ImmutableValues copyOf(Values instance) {
        if (instance instanceof ImmutableValues) {
            return (ImmutableValues)instance;
        }
        return ImmutableValues.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Values", generator="Immutables")
    public static final class Builder {
        private List<Value<?>> values = new ArrayList();

        private Builder() {
        }

        public final Builder from(Values instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllValues(instance.values());
            return this;
        }

        public final Builder addValues(Value<?> element) {
            this.values.add(Objects.requireNonNull(element, "values element"));
            return this;
        }

        @SafeVarargs
        public final Builder addValues(Value<?> ... elements) {
            for (Value<?> element : elements) {
                this.values.add(Objects.requireNonNull(element, "values element"));
            }
            return this;
        }

        public final Builder values(Iterable<? extends Value<?>> elements) {
            this.values.clear();
            return this.addAllValues(elements);
        }

        public final Builder addAllValues(Iterable<? extends Value<?>> elements) {
            for (Value<?> element : elements) {
                this.values.add(Objects.requireNonNull(element, "values element"));
            }
            return this;
        }

        public ImmutableValues build() {
            return new ImmutableValues(ImmutableValues.createUnmodifiableList(true, this.values));
        }
    }
}

